/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.youritemsaresafe_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.CompareItemFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.youritemsaresafe_common_neoforge.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static int processCheck(List<ItemStack> itemStacks, int itemsLeft, String compare, int decrease) {
        for (ItemStack itemStack : itemStacks) {
            if (itemsLeft <= 0) break;
            int count = itemStack.getCount();
            if (!Util.comparePassed(compare, itemStack)) continue;
            while (count > 0 && itemsLeft > 0) {
                itemsLeft -= decrease;
                itemStack.setCount(--count);
            }
        }
        return itemsLeft;
    }

    public static boolean comparePassed(String compare, ItemStack itemStack) {
        return switch (compare) {
            case "log" -> CompareItemFunctions.isLog((ItemStack)itemStack);
            case "plank" -> CompareItemFunctions.isPlank((ItemStack)itemStack);
            case "chest" -> CompareItemFunctions.isChest((ItemStack)itemStack);
            case "stone" -> CompareItemFunctions.isStone((ItemStack)itemStack);
            case "slab" -> CompareItemFunctions.isSlab((ItemStack)itemStack);
            default -> false;
        };
    }

    public static int processLogCheck(List<ItemStack> itemStacks, int planksLeft) {
        return Util.processCheck(itemStacks, planksLeft, "log", 4);
    }

    public static int processPlankCheck(List<ItemStack> itemStacks, int planksLeft) {
        return Util.processCheck(itemStacks, planksLeft, "plank", 1);
    }

    public static int processChestCheck(List<ItemStack> itemStacks, int planksLeft) {
        return Util.processCheck(itemStacks, planksLeft, "chest", 8);
    }

    public static int processStoneCheck(List<ItemStack> itemStacks, int stoneLeft) {
        return Util.processCheck(itemStacks, stoneLeft, "stone", 1);
    }

    public static int processSlabCheck(List<ItemStack> itemStacks, int stoneLeft) {
        return Util.processCheck(itemStacks, stoneLeft, "slab", 1);
    }

    public static boolean hasCurseOfVanishing(ItemStack itemStack) {
        return EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP);
    }

    public static List<ItemStack> getInventoryItems(Player player) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>((Collection<ItemStack>)player.getInventory().getNonEquipmentItems());
        itemStacks.removeIf(Util::hasCurseOfVanishing);
        return itemStacks;
    }

    public static void failureMessage(Player player, int planksLeft, int stoneLeft, int planksNeeded, int stoneNeeded) {
        if (ConfigHandler.sendMessageOnCreationFailure) {
            String failureString = ConfigHandler.creationFailureMessage;
            failureString = failureString.replaceAll("%plankamount%", "" + planksLeft).replaceAll("%stoneamount%", "" + stoneLeft);
            MessageFunctions.sendMessage((Player)player, (String)failureString, (ChatFormatting)ChatFormatting.RED, (boolean)true);
        }
        Level level = player.level();
        Vec3 vec = player.position();
        if (planksLeft != planksNeeded) {
            ItemEntity planks = new ItemEntity(level, vec.x, vec.y + 1.0, vec.z, new ItemStack((ItemLike)Items.OAK_PLANKS, planksNeeded - planksLeft));
            level.addFreshEntity((Entity)planks);
        }
        if (stoneLeft != stoneNeeded) {
            ItemEntity stones = new ItemEntity(level, vec.x, vec.y + 1.0, vec.z, new ItemStack((ItemLike)Items.STONE, stoneNeeded - stoneLeft));
            level.addFreshEntity((Entity)stones);
        }
        Util.deathCoordinatesMessage(player);
    }

    public static void successMessage(Player player) {
        if (ConfigHandler.sendMessageOnCreationSuccess) {
            MessageFunctions.sendMessage((Player)player, (String)ConfigHandler.creationSuccessMessage, (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        }
        Util.deathCoordinatesMessage(player);
    }

    public static void deathCoordinatesMessage(Player player) {
        if (ConfigHandler.sendDeathCoordinatesInChat) {
            BlockPos pPos = player.blockPosition();
            String deathLocationString = " Death Coordinates; x: " + pPos.getX() + ", y: " + pPos.getY() + ", z: " + pPos.getZ() + ".";
            MessageFunctions.sendMessage((Player)player, (String)deathLocationString, (ChatFormatting)ChatFormatting.GRAY);
        }
    }
}

