/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.youritemsaresafe_common_neoforge.events;

import com.natamus.collective_common_neoforge.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_neoforge.functions.CompareBlockFunctions;
import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.collective_common_neoforge.functions.TileEntityFunctions;
import com.natamus.youritemsaresafe_common_neoforge.config.ConfigHandler;
import com.natamus.youritemsaresafe_common_neoforge.data.Constants;
import com.natamus.youritemsaresafe_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DeathEvent {
    public static void onPlayerDeath(ServerPlayer player, DamageSource damageSource, float damageAmount) {
        ArmorStand armourStand;
        boolean isVoidDeath;
        ServerLevel level = player.level();
        if (level.isClientSide()) {
            return;
        }
        String playerName = player.getName().getString();
        List<ItemStack> itemStacks = Util.getInventoryItems((Player)player);
        int totalItemCount = 0;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.isEmpty()) continue;
            ++totalItemCount;
        }
        if (!ConfigHandler.createArmorStand) {
            for (EquipmentSlot slotType : Constants.slotTypes) {
                if (player.getItemBySlot(slotType).isEmpty()) continue;
                ++totalItemCount;
            }
            if (!player.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                ++totalItemCount;
            }
        }
        if (totalItemCount == 0) {
            return;
        }
        BlockPos deathPos = player.blockPosition().atY((int)Math.ceil(player.position().y)).immutable();
        if (deathPos.below().getY() >= level.getMinY() && CompareBlockFunctions.isAirOrOverwritableBlock((Block)level.getBlockState(deathPos.below()).getBlock())) {
            deathPos = deathPos.below().immutable();
        }
        boolean bl = isVoidDeath = deathPos.getY() < level.getMinY() - 32;
        if (!isVoidDeath) {
            if (Constants.inventoryTotemModIsLoaded) {
                for (ItemStack inventoryStack : itemStacks) {
                    if (!inventoryStack.getItem().equals(Items.TOTEM_OF_UNDYING)) continue;
                    return;
                }
            }
            if (player.getMainHandItem().getItem().equals(Items.TOTEM_OF_UNDYING) || player.getOffhandItem().getItem().equals(Items.TOTEM_OF_UNDYING)) {
                return;
            }
        } else {
            int y;
            if (!ConfigHandler.createChestAboveVoid) {
                return;
            }
            for (y = level.getMinY(); y < level.getMaxY(); ++y) {
                BlockPos possiblePos = new BlockPos(deathPos.getX(), y, deathPos.getZ());
                if (!CompareBlockFunctions.isAirOrOverwritableBlock((Block)level.getBlockState(possiblePos).getBlock())) continue;
                deathPos = possiblePos.immutable();
                break;
            }
            if (ConfigHandler.createVoidPlatform) {
                deathPos = deathPos.above().immutable();
                for (BlockPos platformPos : BlockPos.betweenClosed((int)(deathPos.getX() - 1), (int)y, (int)(deathPos.getZ() - 1), (int)(deathPos.getX() + 1), (int)y, (int)(deathPos.getZ() + 1))) {
                    if (!CompareBlockFunctions.isAirOrOverwritableBlock((Block)level.getBlockState(platformPos).getBlock())) continue;
                    level.setBlock(platformPos, Blocks.COBBLESTONE.defaultBlockState(), 3);
                }
            }
        }
        if (ConfigHandler.mustHaveItemsInInventoryForCreation && (ConfigHandler.needChestMaterials || ConfigHandler.needArmorStandMaterials || ConfigHandler.needSignMaterials)) {
            if (ConfigHandler.createArmorStand && ConfigHandler.addPlayerHeadToArmorStand && !player.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                ++totalItemCount;
            }
            int stoneleft = 1;
            int planksleft = 0;
            if (ConfigHandler.needChestMaterials) {
                planksleft += 8;
                if (totalItemCount > 27) {
                    planksleft += 8;
                }
                planksleft = Util.processChestCheck(itemStacks, planksleft);
            }
            if (ConfigHandler.createArmorStand && ConfigHandler.needArmorStandMaterials) {
                planksleft += 3;
            }
            if (ConfigHandler.createSignWithPlayerName && ConfigHandler.needSignMaterials) {
                planksleft += 7;
            }
            if (ConfigHandler.ignoreStoneMaterialNeed) {
                stoneleft = 0;
            }
            int planksneeded = planksleft;
            int stoneneeded = stoneleft;
            if (planksleft > 0) {
                planksleft = Util.processLogCheck(itemStacks, planksleft);
            }
            if (planksleft > 0) {
                planksleft = Util.processPlankCheck(itemStacks, planksleft);
            }
            if (planksleft > 0) {
                planksleft = Util.processChestCheck(itemStacks, planksleft);
            }
            if (planksleft > 0) {
                Util.failureMessage((Player)player, planksleft, stoneleft, planksneeded, stoneneeded);
                return;
            }
            if (stoneleft > 0) {
                stoneleft = Util.processStoneCheck(itemStacks, stoneleft);
            }
            if (stoneleft > 0) {
                stoneleft = Util.processSlabCheck(itemStacks, stoneleft);
            }
            if (stoneleft > 0) {
                Util.failureMessage((Player)player, planksleft, stoneleft, planksneeded, stoneneeded);
                return;
            }
        }
        ArrayList<EquipmentSlot> localSlotTypes = new ArrayList<EquipmentSlot>(Constants.slotTypes);
        if (ConfigHandler.createArmorStand) {
            ItemStack helmetStack = null;
            armourStand = new ArmorStand(EntityType.ARMOR_STAND, (Level)level);
            if (ConfigHandler.addPlayerHeadToArmorStand) {
                ItemStack headStack = PlayerHeadCacheFeature.getPlayerHeadStackFromCache((Player)player);
                if (headStack == null) {
                    headStack = PlayerHeadCacheFeature.getPlayerHeadStackFromCache((ServerLevel)level, (String)player.getName().getString());
                }
                if (headStack != null) {
                    if (!player.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                        helmetStack = player.getItemBySlot(EquipmentSlot.HEAD).copy();
                        player.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                    armourStand.setItemSlot(EquipmentSlot.HEAD, headStack);
                    localSlotTypes.remove(EquipmentSlot.HEAD);
                }
            }
            for (EquipmentSlot slotType : localSlotTypes) {
                ItemStack slotStack = player.getItemBySlot(slotType).copy();
                if (slotStack.isEmpty() || Util.hasCurseOfVanishing(slotStack)) continue;
                armourStand.setItemSlot(slotType, slotStack);
                player.setItemSlot(slotType, ItemStack.EMPTY);
            }
            itemStacks = Util.getInventoryItems((Player)player);
            if (helmetStack != null && !Util.hasCurseOfVanishing(helmetStack)) {
                itemStacks.add(helmetStack);
            }
        } else {
            armourStand = null;
            for (EquipmentSlot slotType : localSlotTypes) {
                ItemStack slotStack;
                if (slotType.equals((Object)EquipmentSlot.MAINHAND) || (slotStack = player.getItemBySlot(slotType).copy()).isEmpty() || Util.hasCurseOfVanishing(slotStack)) continue;
                itemStacks.add(slotStack);
                player.setItemSlot(slotType, ItemStack.EMPTY);
            }
        }
        BlockPos finalDeathPos = deathPos;
        List<ItemStack> finalItemStacks = itemStacks;
        TaskFunctions.enqueueCollectiveTask((MinecraftServer)level.getServer(), () -> DeathEvent.lambda$onPlayerDeath$0(finalDeathPos, (Level)level, finalItemStacks, armourStand, player, playerName), (int)1);
    }

    private static /* synthetic */ void lambda$onPlayerDeath$0(BlockPos finalDeathPos, Level level, List finalItemStacks, ArmorStand armourStand, ServerPlayer player, String playerName) {
        int chestCount = 1;
        BlockState chestState = (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestBlockEntity chestEntity = new ChestBlockEntity(finalDeathPos, chestState);
        level.setBlock(finalDeathPos, chestState, 3);
        level.setBlockEntity((BlockEntity)chestEntity);
        BlockPos deathPosUp = new BlockPos(finalDeathPos.getX(), finalDeathPos.getY() + 1, finalDeathPos.getZ());
        ChestBlockEntity chestEntityTwo = new ChestBlockEntity(deathPosUp, chestState);
        int i = 0;
        for (ItemStack itemStack : finalItemStacks) {
            if (itemStack.isEmpty()) continue;
            if (i < 27) {
                chestEntity.setItem(i, itemStack.copy());
                itemStack.setCount(0);
            } else if (i >= 27) {
                if (chestCount == 1) {
                    ++chestCount;
                    level.setBlock(deathPosUp, chestState, 3);
                    level.setBlockEntity((BlockEntity)chestEntityTwo);
                }
                if (i - 27 > 26) break;
                chestEntityTwo.setItem(i - 27, itemStack.copy());
                itemStack.setCount(0);
            }
            ++i;
        }
        if (armourStand != null) {
            armourStand.setPos((double)finalDeathPos.getX() + 0.5, (double)(finalDeathPos.getY() + chestCount), (double)finalDeathPos.getZ() + 0.5);
            armourStand.getEntityData().set(ArmorStand.DATA_CLIENT_FLAGS, (Object)DataFunctions.setBit((byte)((Byte)armourStand.getEntityData().get(ArmorStand.DATA_CLIENT_FLAGS)), (int)4, (boolean)true));
            level.addFreshEntity((Entity)armourStand);
        }
        Util.successMessage((Player)player);
        if (ConfigHandler.createSignWithPlayerName) {
            BlockPos signPos = finalDeathPos.south().immutable();
            level.setBlockAndUpdate(signPos, (BlockState)Blocks.OAK_WALL_SIGN.defaultBlockState().setValue((Property)WallSignBlock.FACING, (Comparable)Direction.SOUTH));
            BlockEntity blockEntity = level.getBlockEntity(signPos);
            if (!(blockEntity instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
            signBlockEntity.setText(signBlockEntity.getFrontText().setMessage(1, (Component)Component.literal((String)playerName)), true);
            TileEntityFunctions.updateTileEntity((Level)level, (BlockPos)signPos, (BlockEntity)signBlockEntity);
        }
    }
}

