/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.vanillazoom_common_forge.events;

import com.mojang.blaze3d.platform.InputConstants;
import com.natamus.collective_common_forge.functions.KeyMappingFunctions;
import com.natamus.vanillazoom_common_forge.util.Variables;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class ZoomEvent {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final KeyMapping useKeyMapping = ZoomEvent.mc.options.keyUse;
    public static boolean showZoom = false;
    private static ItemStack previousStack = null;

    public static void onClientTick() {
        if (Variables.hotkey == null) {
            return;
        }
        LocalPlayer player = ZoomEvent.mc.player;
        if (player == null) {
            return;
        }
        if (!player.level().isClientSide()) {
            return;
        }
        InputConstants.Key key = KeyMappingFunctions.getKey((KeyMapping)useKeyMapping);
        boolean forceRelease = false;
        if (showZoom) {
            KeyMapping.set((InputConstants.Key)key, (boolean)true);
            KeyMapping.click((InputConstants.Key)key);
            if (!(player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof SpyglassItem)) {
                forceRelease = true;
            }
        }
        if (Variables.hotkey.isDown() && !forceRelease) {
            if (!showZoom) {
                showZoom = true;
                previousStack = player.getItemInHand(InteractionHand.OFF_HAND).copy();
                ItemStack spyglassStack = new ItemStack((ItemLike)Items.SPYGLASS);
                spyglassStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)""));
                player.setItemInHand(InteractionHand.OFF_HAND, spyglassStack);
            }
        } else if (showZoom) {
            showZoom = false;
            KeyMapping.set((InputConstants.Key)key, (boolean)false);
            if (previousStack != null) {
                player.setItemInHand(InteractionHand.OFF_HAND, previousStack.copy());
                previousStack = null;
            }
        }
    }

    public static InteractionResult onItemUse(Player player, Level level, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (showZoom && !(itemStack.getItem() instanceof SpyglassItem)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onEntityInteract(Player player, Level level, InteractionHand hand, Entity entity, EntityHitResult hitResult) {
        if (showZoom) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

