/*
 * Decompiled with CFR 0.152.
 */
package io.tythee;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObjectPool<T> {
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();
    private final ObjectFactory<T> factory;
    private final ObjectResetter<T> resetter;

    public ObjectPool(ObjectFactory<T> factory, ObjectResetter<T> resetter) {
        this.factory = factory;
        this.resetter = resetter;
    }

    public T borrow() {
        T obj = this.pool.poll();
        if (obj == null) {
            obj = this.factory.create();
        }
        return obj;
    }

    public void returnObject(T obj) {
        if (obj != null) {
            this.resetter.reset(obj);
            this.pool.offer(obj);
        }
    }

    public static interface ObjectFactory<T> {
        public T create();
    }

    public static interface ObjectResetter<T> {
        public void reset(T var1);
    }
}

