/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config.blocksound;

import com.sonicether.soundphysics.config.SoundTypes;
import com.sonicether.soundphysics.config.blocksound.BlockDefinition;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_2498;
import net.minecraft.class_2561;

public class BlockSoundTypeDefinition
extends BlockDefinition {
    private final class_2498 soundType;

    public BlockSoundTypeDefinition(class_2498 soundType) {
        this.soundType = soundType;
    }

    @Override
    public String getConfigString() {
        return SoundTypes.getName(this.soundType);
    }

    @Override
    @Nullable
    public String getConfigComment() {
        return this.getName().getString();
    }

    @Override
    public class_2561 getName() {
        return SoundTypes.getNameComponent(this.soundType).method_10852((class_2561)class_2561.method_43470((String)" (Sound Type)"));
    }

    public class_2498 getSoundType() {
        return this.soundType;
    }

    @Nullable
    public static BlockSoundTypeDefinition fromConfigString(String configString) {
        class_2498 soundType = SoundTypes.getSoundType(configString);
        if (soundType == null) {
            return null;
        }
        return new BlockSoundTypeDefinition(soundType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockSoundTypeDefinition that = (BlockSoundTypeDefinition)o;
        return Objects.equals(this.soundType, that.soundType);
    }

    public int hashCode() {
        return this.soundType != null ? this.soundType.hashCode() : 0;
    }
}

