/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.thosea.badoptimizations.hook;

import fabric.me.thosea.badoptimizations.config.Config;
import fabric.me.thosea.badoptimizations.utils.PlatformMethods;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.Nullable;

public final class CacheHooks {
    public static final String ROOT_KEY = "badoptimizations:cache_hooks";
    public static final String COMMON_KEY = "common";
    public static final String LIGHTMAP_KEY = "lightmap";
    public static final String SKYCOLOR_KEY = "skycolor";
    private static final BooleanSupplier[] COMMON_COLOR_HOOKS;
    private static final BooleanSupplier[] LIGHTMAP_HOOKS;
    private static final BooleanSupplier[] SKYCOLOR_HOOKS;

    private CacheHooks() {
    }

    public static void init() {
    }

    public static boolean invokeCommon() {
        if (Config.ignoreCacheHooks) {
            return false;
        }
        for (BooleanSupplier hook : COMMON_COLOR_HOOKS) {
            if (!hook.getAsBoolean()) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeLightmap() {
        if (Config.ignoreCacheHooks) {
            return false;
        }
        for (BooleanSupplier hook : LIGHTMAP_HOOKS) {
            if (!hook.getAsBoolean()) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeSkyColor() {
        if (Config.ignoreCacheHooks) {
            return false;
        }
        for (BooleanSupplier hook : SKYCOLOR_HOOKS) {
            if (!hook.getAsBoolean()) continue;
            return true;
        }
        return false;
    }

    static {
        if (Config.ignoreCacheHooks) {
            Config.LOGGER.warn("Ignore mod cache hooks is enabled!");
            COMMON_COLOR_HOOKS = new BooleanSupplier[0];
            LIGHTMAP_HOOKS = new BooleanSupplier[0];
            SKYCOLOR_HOOKS = new BooleanSupplier[0];
        } else {
            ArrayList commonHooks = new ArrayList();
            ArrayList lightmapHooks = new ArrayList();
            ArrayList skyColorHooks = new ArrayList();
            PlatformMethods.getModCacheHooks().forEach(hook -> {
                if (hook.commonHook != null) {
                    commonHooks.add(hook.commonHook);
                }
                if (hook.lightmapHook != null) {
                    lightmapHooks.add(hook.lightmapHook);
                }
                if (hook.skyColorHook != null) {
                    skyColorHooks.add(hook.skyColorHook);
                }
            });
            BooleanSupplier[] dummy = new BooleanSupplier[]{};
            COMMON_COLOR_HOOKS = commonHooks.toArray(dummy);
            LIGHTMAP_HOOKS = lightmapHooks.toArray(dummy);
            SKYCOLOR_HOOKS = skyColorHooks.toArray(dummy);
        }
    }

    public record CacheHookEntry(@Nullable BooleanSupplier commonHook, @Nullable BooleanSupplier lightmapHook, @Nullable BooleanSupplier skyColorHook) {
    }
}

