/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.deathbackup_common_fabric.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_fabric.functions.DateFunctions;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.PlayerFunctions;
import com.natamus.deathbackup_common_fabric.util.Util;
import java.util.List;
import net.minecraft.class_12099;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class CommandDeathBackup {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"deathbackup").requires(iCommandSender -> iCommandSender.method_75037().hasPermission(class_12099.field_63211))).executes(command -> {
            class_2168 source = (class_2168)command.getSource();
            MessageFunctions.sendMessage((class_2168)source, (String)"Death Backup usage:", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"/deathbackup list - Lists all available backups.", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"/deathbackup load <index> - Loads the backup with <index> from '/deathbackup list'. Index 0 is the last death.", (class_124)class_124.field_1077);
            return 1;
        })).then(class_2170.method_9247((String)"list").executes(command -> {
            class_3222 player;
            class_2168 source = (class_2168)command.getSource();
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException ex) {
                MessageFunctions.sendMessage((class_2168)source, (String)"This command can only be executed as a player in-game.", (class_124)class_124.field_1061);
                return 1;
            }
            class_1937 world = player.method_73183();
            if (world.method_8608()) {
                MessageFunctions.sendMessage((class_2168)source, (String)"[Error] The world is not remote, unable to load death backup.", (class_124)class_124.field_1061);
                return 1;
            }
            if (!(world instanceof class_3218)) {
                MessageFunctions.sendMessage((class_2168)source, (String)"[Error] Cannot find the world's server, unable to load death backup.", (class_124)class_124.field_1061);
                return 1;
            }
            String playername = player.method_5477().getString().toLowerCase();
            class_3218 serverworld = (class_3218)world;
            List<String> backups = Util.getListOfBackups(serverworld, playername);
            MessageFunctions.sendMessage((class_2168)source, (String)"Last Death Backups: (<index>: <date>)", (class_124)class_124.field_1077, (boolean)true);
            int index = 0;
            for (String ymdhis : backups) {
                MessageFunctions.sendMessage((class_2168)source, (String)(" " + index + ": " + DateFunctions.ymdhisToReadable((String)ymdhis)), (class_124)class_124.field_1077);
                if (++index != 10) continue;
                break;
            }
            MessageFunctions.sendMessage((class_2168)source, (String)"Load the backup with '/deathbackup load <index>'.", (class_124)class_124.field_1054);
            return 1;
        }))).then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"backup_index", (ArgumentType)IntegerArgumentType.integer()).executes(command -> {
            class_3222 player;
            class_2168 source = (class_2168)command.getSource();
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException ex) {
                MessageFunctions.sendMessage((class_2168)source, (String)"This command can only be executed as a player in-game.", (class_124)class_124.field_1061);
                return 1;
            }
            class_1937 world = player.method_73183();
            if (world.method_8608()) {
                MessageFunctions.sendMessage((class_2168)source, (String)"[Error] The world is not remote, unable to load death backup.", (class_124)class_124.field_1061);
                return 1;
            }
            if (!(world instanceof class_3218)) {
                MessageFunctions.sendMessage((class_2168)source, (String)"[Error] Cannot find the world's server, unable to load death backup.", (class_124)class_124.field_1061);
                return 1;
            }
            String playername = player.method_5477().getString().toLowerCase();
            class_3218 serverworld = (class_3218)world;
            List<String> backups = Util.getListOfBackups(serverworld, playername);
            int amount = IntegerArgumentType.getInteger((CommandContext)command, (String)"backup_index");
            if (amount < 0 || amount >= backups.size()) {
                MessageFunctions.sendMessage((class_2168)source, (String)("The index " + amount + " is invalid."), (class_124)class_124.field_1061);
                return 0;
            }
            String backupfilename = backups.get(amount);
            String gearstring = Util.getGearStringFromFile(serverworld, playername, backupfilename);
            if (gearstring.equals("")) {
                MessageFunctions.sendMessage((class_2168)source, (String)"[Error] Unable to read the backup file.", (class_124)class_124.field_1061);
                return 0;
            }
            PlayerFunctions.setPlayerGearFromString((class_1657)player, (String)gearstring);
            MessageFunctions.sendMessage((class_2168)source, (String)("Successfully loaded the death backup from " + DateFunctions.ymdhisToReadable((String)backupfilename) + " into your inventory."), (class_124)class_124.field_1077);
            return 1;
        }))));
    }
}

