/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.persistentinventorysearch_common_neoforge.mixin;

import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.world.item.CreativeModeTab;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class}, priority=1001)
public abstract class CreativeModeInventoryScreenMixin {
    @Shadow
    private static CreativeModeTab selectedTab;
    @Shadow
    private EditBox searchBox;
    @Unique
    private static String searchQuery;

    @Shadow
    protected abstract void refreshSearchResults();

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void CreativeModeInventoryScreen_init(CallbackInfo ci) {
        if (selectedTab.getType().equals((Object)CreativeModeTab.Type.SEARCH) && !searchQuery.isEmpty()) {
            this.searchBox.setValue(searchQuery);
            this.refreshSearchResults();
        }
    }

    @Inject(method={"keyReleased(Lnet/minecraft/client/input/KeyEvent;)Z"}, at={@At(value="HEAD")})
    public void CreativeModeInventoryScreen_keyReleased(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchBox.isFocused() && this.searchBox.isVisible()) {
            searchQuery = this.searchBox.getValue();
        }
    }

    @Inject(method={"selectTab(Lnet/minecraft/world/item/CreativeModeTab;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;refreshSearchResults()V")})
    private void selectTab(CreativeModeTab p_98561_, CallbackInfo ci) {
        if (selectedTab.getType().equals((Object)CreativeModeTab.Type.SEARCH) && !searchQuery.isEmpty()) {
            this.searchBox.setValue(searchQuery);
        }
    }

    static {
        searchQuery = "";
    }
}

