/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.alwaysawitherskull_common_neoforge.mixin;

import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.skeleton.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class}, priority=1001)
public class WitherSkeletonMixin {
    @Inject(method={"dropCustomDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;Z)V"}, at={@At(value="HEAD")})
    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean b, CallbackInfo ci) {
        Mob mob = (Mob)this;
        if (!(mob instanceof WitherSkeleton)) {
            return;
        }
        WitherSkeleton witherSkeleton = (WitherSkeleton)mob;
        Vec3 witherVec = witherSkeleton.position();
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> {
            boolean foundSkull = false;
            for (Entity entity : serverLevel.getEntities(null, new AABB(witherVec.x - 1.0, witherVec.y - 1.0, witherVec.z - 1.0, witherVec.x + 1.0, witherVec.y + 1.0, witherVec.z + 1.0))) {
                ItemEntity itemEntity;
                if (!(entity instanceof ItemEntity) || !(itemEntity = (ItemEntity)entity).getItem().getItem().equals(Items.WITHER_SKELETON_SKULL) || itemEntity.getAge() >= 10) continue;
                foundSkull = true;
                break;
            }
            if (!foundSkull) {
                serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, witherVec.x, witherVec.y, witherVec.z, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, 1)));
            }
        }, (int)1);
    }
}

