/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.tntbreaksbedrock_common_forge.events;

import com.natamus.collective_common_forge.functions.ExplosionFunctions;
import com.natamus.tntbreaksbedrock_common_forge.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BoomEvent {
    public static void onExplosion(Level world, Entity sourceEntity, Explosion explosion) {
        if (world.isClientSide()) {
            return;
        }
        List affected = ExplosionFunctions.getAffectedBlockPositions((Explosion)explosion);
        if (affected.size() == 0) {
            return;
        }
        if (!(sourceEntity instanceof PrimedTnt)) {
            return;
        }
        ArrayList<BlockPos> bedrocks = new ArrayList<BlockPos>();
        for (BlockPos pos : affected) {
            for (BlockPos bedpos : Util.getBedrocks(world, pos.immutable())) {
                if (bedrocks.contains(bedpos.immutable())) continue;
                bedrocks.add(bedpos.immutable());
            }
        }
        BlockState air = Blocks.AIR.defaultBlockState();
        for (BlockPos bedrock : bedrocks) {
            world.setBlockAndUpdate(bedrock, air);
        }
    }
}

