/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.campfirespawnandtweaks_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.campfirespawnandtweaks_common_forge.config.ConfigHandler;
import com.natamus.campfirespawnandtweaks_common_forge.util.Util;
import com.natamus.collective_common_forge.functions.BlockFunctions;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.collective_common_forge.services.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CampfireEvent {
    public static HashMap<String, Pair<Level, BlockPos>> playercampfires = new HashMap();
    public static HashMap<Level, List<Pair<Player, BlockPos>>> playerstorespawn = new HashMap();
    private static final HashMap<Level, List<BlockPos>> firestoextinguish = new HashMap();
    private static final List<Block> extinguishblocks = new ArrayList<Block>(Arrays.asList(Blocks.DIRT, Blocks.GRASS_BLOCK, Blocks.SAND, Blocks.RED_SAND, Blocks.SOUL_SAND));

    public static void onWorldLoad(ServerLevel level) {
        Util.loadCampfireSpawnsFromWorld((Level)level);
    }

    public static void onWorldTick(ServerLevel level) {
        if (((List)HashMapFunctions.computeIfAbsent(firestoextinguish, (Object)level, k -> new ArrayList())).size() > 0) {
            BlockPos campfirepos = firestoextinguish.get(level).get(0);
            BlockState state = level.getBlockState(campfirepos);
            if (state.getBlock() instanceof CampfireBlock) {
                level.setBlockAndUpdate(campfirepos, (BlockState)((BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CampfireBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            }
            firestoextinguish.get(level).remove(0);
        }
        if (((List)HashMapFunctions.computeIfAbsent(playerstorespawn, (Object)level, k -> new ArrayList())).size() > 0) {
            Pair<Player, BlockPos> pair = playerstorespawn.get(level).get(0);
            Player player = (Player)pair.getFirst();
            BlockPos respawnpos = (BlockPos)pair.getSecond();
            if (player instanceof ServerPlayer) {
                if (level.getBlockState(respawnpos).getBlock() instanceof CampfireBlock) {
                    Vec3 ts;
                    ServerPlayer serverplayer = (ServerPlayer)player;
                    int fireresistancems = ConfigHandler.fireResitanceDurationOnRespawnInMs;
                    if (fireresistancems > 0) {
                        ts = new Vec3((double)respawnpos.getX() + 0.5, (double)respawnpos.getY() + 0.5, (double)respawnpos.getZ() + 0.5);
                        EntityFunctions.addPotionEffect((Entity)player, (Holder)MobEffects.FIRE_RESISTANCE, (Integer)fireresistancems);
                    } else {
                        ts = new Vec3((double)respawnpos.getX() + 1.5, (double)respawnpos.getY(), (double)respawnpos.getZ() + 0.5);
                    }
                    if (ConfigHandler.createAirPocketIfBlocksAboveCampfire) {
                        BlockPos tsbp = BlockPos.containing((double)ts.x, (double)ts.y, (double)ts.z);
                        Iterator posaround = BlockPos.betweenClosedStream((int)tsbp.getX(), (int)tsbp.getY(), (int)tsbp.getZ(), (int)tsbp.getX(), (int)(tsbp.getY() + 1), (int)tsbp.getZ()).iterator();
                        while (posaround.hasNext()) {
                            BlockPos around = (BlockPos)posaround.next();
                            Block block = level.getBlockState(around).getBlock();
                            if (block.equals(Blocks.AIR) || block instanceof CampfireBlock) continue;
                            BlockFunctions.dropBlock((Level)level, (BlockPos)around);
                        }
                    }
                    serverplayer.teleportTo(level, ts.x, ts.y, ts.z, Relative.ALL, player.getYRot(), player.getXRot(), true);
                } else {
                    String playername = player.getName().toString();
                    playercampfires.remove(playername.toLowerCase());
                    if (ConfigHandler.sendMessageOnCampfireSpawnMissing) {
                        MessageFunctions.sendMessage((Player)player, (String)"Campfire spawn point missing.", (ChatFormatting)ChatFormatting.DARK_GRAY);
                    }
                }
            }
            playerstorespawn.get(level).remove(0);
        }
    }

    public static boolean onEntityBlockPlace(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack itemStack) {
        if (level.isClientSide()) {
            return true;
        }
        if (!(entity instanceof Player)) {
            return true;
        }
        Block block = state.getBlock();
        if (block instanceof CampfireBlock) {
            Player player = (Player)entity;
            if (Services.TOOLFUNCTIONS.isFlintAndSteel(player.getMainHandItem()) || Services.TOOLFUNCTIONS.isFlintAndSteel(player.getOffhandItem())) {
                return true;
            }
            if (ConfigHandler.campfiresStartUnlit) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
                return false;
            }
        }
        return true;
    }

    public static boolean onRightClickCampfireBlock(Level level, Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
        if (level.isClientSide()) {
            return true;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        boolean allowAction = true;
        if (block instanceof CampfireBlock) {
            String playername = player.getName().getString();
            if (player.isShiftKeyDown() && ConfigHandler.sneakRightClickCampfireToUnset) {
                if (Util.checkForCampfireSpawnRemoval(level, playername, pos) && ConfigHandler.sendMessageOnNewCampfireSpawnSet) {
                    MessageFunctions.sendMessage((Player)player, (String)"Campfire spawn point removed.", (ChatFormatting)ChatFormatting.DARK_GRAY);
                }
                return true;
            }
            ItemStack itemstack = player.getItemInHand(hand);
            Item item = itemstack.getItem();
            boolean holdinglighter = false;
            if (Services.TOOLFUNCTIONS.isFlintAndSteel(player.getMainHandItem()) || Services.TOOLFUNCTIONS.isFlintAndSteel(player.getOffhandItem())) {
                holdinglighter = true;
                if (((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                    allowAction = false;
                }
            }
            boolean removed = false;
            if (((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue() || holdinglighter) {
                boolean iswaterbucket = item.equals(Items.WATER_BUCKET);
                Block itemblock = Block.byItem((Item)item);
                if (extinguishblocks.contains(itemblock) || iswaterbucket && !holdinglighter) {
                    if (!player.isCreative() && !iswaterbucket) {
                        itemstack.shrink(1);
                    }
                    allowAction = false;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
                    if (iswaterbucket) {
                        ((List)HashMapFunctions.computeIfAbsent(firestoextinguish, (Object)level, k -> new ArrayList())).add(pos);
                    }
                    if (Util.checkForCampfireSpawnRemoval(level, playername, pos) && ConfigHandler.sendMessageOnNewCampfireSpawnSet) {
                        MessageFunctions.sendMessage((Player)player, (String)"Campfire spawn point removed.", (ChatFormatting)ChatFormatting.DARK_GRAY);
                    }
                    removed = true;
                }
                if (!removed && hand.equals((Object)InteractionHand.MAIN_HAND) && (holdinglighter || itemstack.isEmpty())) {
                    boolean replaced = playercampfires.containsKey(playername.toLowerCase());
                    BlockPos oldpos = null;
                    if (replaced) {
                        oldpos = ((BlockPos)playercampfires.get(playername.toLowerCase()).getSecond()).immutable();
                    }
                    if (Util.setCampfireSpawn(level, playername, pos) && ConfigHandler.sendMessageOnNewCampfireSpawnSet) {
                        if (holdinglighter) {
                            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CampfireBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                            player.swing(hand);
                        }
                        if (replaced) {
                            if (oldpos.equals((Object)pos)) {
                                MessageFunctions.sendMessage((Player)player, (String)"Campfire spawn point remains the same.", (ChatFormatting)ChatFormatting.DARK_GRAY);
                                return true;
                            }
                            MessageFunctions.sendMessage((Player)player, (String)"Campfire spawn point replaced.", (ChatFormatting)ChatFormatting.DARK_GRAY);
                            return true;
                        }
                        MessageFunctions.sendMessage((Player)player, (String)"Campfire spawn point set.", (ChatFormatting)ChatFormatting.DARK_GRAY);
                    }
                }
            }
        } else if (block instanceof BedBlock && player.isShiftKeyDown()) {
            if (!ConfigHandler.bedsOverrideCampfireSpawnOnSneakRightClick) {
                return true;
            }
            String playername = player.getName().getString().toLowerCase();
            if (playercampfires.containsKey(playername)) {
                BlockPos newspawn = pos.immutable();
                Pair<Level, BlockPos> pair = playercampfires.get(playername);
                Level oldlevel = (Level)pair.getFirst();
                BlockPos oldpos = (BlockPos)pair.getSecond();
                if (WorldFunctions.getWorldDimensionName((Level)level).equals(WorldFunctions.getWorldDimensionName((Level)oldlevel)) && newspawn.equals((Object)oldpos)) {
                    return true;
                }
                if (Util.checkForCampfireSpawnRemoval(level, playername, oldpos) && ConfigHandler.sendMessageOnCampfireSpawnOverride) {
                    MessageFunctions.sendMessage((Player)player, (String)"Campfire spawn point unset.", (ChatFormatting)ChatFormatting.DARK_GRAY);
                }
            }
        }
        return allowAction;
    }

    public static void onCampfireBreak(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        String playername;
        if (level.isClientSide()) {
            return;
        }
        if (level.getBlockState(pos).getBlock() instanceof CampfireBlock && Util.checkForCampfireSpawnRemoval(level, playername = player.getName().getString().toLowerCase(), pos) && ConfigHandler.sendMessageOnNewCampfireSpawnSet) {
            MessageFunctions.sendMessage((Player)player, (String)"Campfire spawn point removed.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        }
    }

    public static void onPlayerRespawn(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean alive) {
        ServerLevel level = newPlayer.level();
        if (level.isClientSide()) {
            return;
        }
        String playername = newPlayer.getName().getString().toLowerCase();
        if (!playercampfires.containsKey(playername)) {
            return;
        }
        Pair<Level, BlockPos> pair = playercampfires.get(playername);
        ((List)HashMapFunctions.computeIfAbsent(playerstorespawn, (Object)((Level)pair.getFirst()), k -> new ArrayList())).add(new Pair((Object)newPlayer, (Object)((BlockPos)pair.getSecond()).immutable()));
    }
}

