/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.campfirespawnandtweaks.neoforge.events;

import com.natamus.campfirespawnandtweaks_common_neoforge.events.CampfireEvent;
import com.natamus.collective_common_neoforge.functions.WorldFunctions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class NeoForgeCampfireEvent {
    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        CampfireEvent.onWorldLoad((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post e) {
        Level level = e.getLevel();
        if (level.isClientSide()) {
            return;
        }
        CampfireEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onEntityBlockPlace(BlockEvent.EntityPlaceEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        CampfireEvent.onEntityBlockPlace(level, e.getPos(), e.getPlacedBlock(), (LivingEntity)entity, null);
    }

    @SubscribeEvent
    public static void onRightClickCampfireBlock(PlayerInteractEvent.RightClickBlock e) {
        if (!CampfireEvent.onRightClickCampfireBlock(e.getLevel(), e.getEntity(), e.getHand(), e.getPos(), e.getHitVec())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCampfireBreak(BlockEvent.BreakEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        CampfireEvent.onCampfireBreak(level, e.getPlayer(), e.getPos(), e.getState(), null);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        Player player = e.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        CampfireEvent.onPlayerRespawn(null, (ServerPlayer)player, true);
    }
}

