/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.campfirespawnandtweaks;

import com.natamus.campfirespawnandtweaks_common_fabric.ModCommon;
import com.natamus.campfirespawnandtweaks_common_fabric.events.CampfireEvent;
import com.natamus.collective.fabric.callbacks.CollectiveBlockEvents;
import com.natamus.collective_common_fabric.check.RegisterMod;
import com.natamus.collective_common_fabric.check.ShouldLoadCheck;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;

public class ModFabric
implements ModInitializer {
    public void onInitialize() {
        if (!ShouldLoadCheck.shouldLoad((String)"campfirespawnandtweaks")) {
            return;
        }
        ModFabric.setGlobalConstants();
        ModCommon.init();
        this.loadEvents();
        RegisterMod.register((String)"Campfire Spawn and Tweaks", (String)"campfirespawnandtweaks", (String)"4.1", (String)"[1.21.11]");
    }

    private void loadEvents() {
        ServerWorldEvents.LOAD.register((server, world) -> CampfireEvent.onWorldLoad(world));
        ServerTickEvents.START_WORLD_TICK.register(world -> CampfireEvent.onWorldTick(world));
        CollectiveBlockEvents.BLOCK_PLACE.register((level, blockPos, blockState, livingEntity, itemStack) -> CampfireEvent.onEntityBlockPlace(level, blockPos, blockState, livingEntity, itemStack));
        CollectiveBlockEvents.BLOCK_RIGHT_CLICK.register((world, player, hand, pos, hitVec) -> CampfireEvent.onRightClickCampfireBlock(world, player, hand, pos, hitVec));
        CollectiveBlockEvents.BLOCK_DESTROY.register((level, player, blockPos, blockState, blockEntity, itemStack) -> {
            CampfireEvent.onCampfireBreak(level, player, blockPos, blockState, blockEntity);
            return true;
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> CampfireEvent.onPlayerRespawn(oldPlayer, newPlayer, alive));
    }

    private static void setGlobalConstants() {
    }
}

