/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.euphoria_patcher.util.IrisReloadManager;

public class PotatoFileMonitor {
    private static final Map<String, Boolean> potatoCache = new HashMap<String, Boolean>();
    private static volatile String currentShaderpackPath = null;
    private static volatile Boolean lastKnownState = null;
    private static volatile Boolean initialState = null;
    private static final AtomicInteger monitorLogCount = new AtomicInteger(0);
    private static Thread potatoMonitorThread = null;
    private static volatile boolean running = false;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[PotatoFileMonitor] " + message);
    }

    public static boolean checkPotatoExists(Path shaderpackPath) {
        if (shaderpackPath == null) {
            PotatoFileMonitor.debugLog("Shaderpack path is null");
            return false;
        }
        String pathKey = shaderpackPath.toString();
        if (potatoCache.containsKey(pathKey)) {
            boolean cachedValue = potatoCache.get(pathKey);
            PotatoFileMonitor.debugLog("Using cached value for " + pathKey + ": " + cachedValue);
            return cachedValue;
        }
        boolean exists = PotatoFileMonitor.performPotatoCheck(shaderpackPath);
        potatoCache.put(pathKey, exists);
        PotatoFileMonitor.debugLog("Cached new value for " + pathKey + ": " + exists);
        return exists;
    }

    public static void setCurrentShaderpack(Path shaderpackPath) {
        if (shaderpackPath == null) {
            currentShaderpackPath = null;
            lastKnownState = null;
            initialState = null;
            monitorLogCount.set(0);
            return;
        }
        String pathKey = shaderpackPath.toString();
        if (!pathKey.equals(currentShaderpackPath)) {
            PotatoFileMonitor.debugLog("Shaderpack changed from " + currentShaderpackPath + " to " + pathKey);
            currentShaderpackPath = pathKey;
            boolean potatoExists = PotatoFileMonitor.checkPotatoExists(shaderpackPath);
            lastKnownState = potatoExists;
            initialState = potatoExists;
            monitorLogCount.set(0);
            PotatoFileMonitor.debugLog("Initial potato.png state for new shaderpack: " + initialState);
        }
    }

    public static void startMonitoring() {
        if (running) {
            PotatoFileMonitor.debugLog("Monitoring already running");
            return;
        }
        running = true;
        potatoMonitorThread = new Thread(() -> {
            PotatoFileMonitor.debugLog("Started potato.png monitoring thread");
            while (running) {
                try {
                    if (currentShaderpackPath != null && initialState != null && initialState.booleanValue()) {
                        Path shaderpackPath = new File(currentShaderpackPath).toPath();
                        boolean currentState = PotatoFileMonitor.performPotatoCheck(shaderpackPath);
                        if (currentState != lastKnownState) {
                            PotatoFileMonitor.debugLog("Potato.png state changed from " + lastKnownState + " to " + currentState);
                            potatoCache.put(currentShaderpackPath, currentState);
                            lastKnownState = currentState;
                            monitorLogCount.set(0);
                            if (currentState) {
                                PotatoFileMonitor.debugLog("potato.png has returned - triggering shader reload");
                            } else {
                                PotatoFileMonitor.debugLog("potato.png has been removed - triggering shader reload");
                            }
                            IrisReloadManager.findAndScheduleReload();
                        } else if (monitorLogCount.get() < 6) {
                            monitorLogCount.incrementAndGet();
                            if (currentState) {
                                PotatoFileMonitor.debugLog("Monitoring: potato.png is present (" + monitorLogCount.get() + "/6)");
                            } else {
                                PotatoFileMonitor.debugLog("Monitoring: potato.png is absent (" + monitorLogCount.get() + "/6)");
                            }
                        } else if (monitorLogCount.get() == 6) {
                            monitorLogCount.incrementAndGet();
                            PotatoFileMonitor.debugLog("Monitoring: potato.png state stable, no changes detected, will continue monitoring silently.");
                        }
                    }
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e) {
                    PotatoFileMonitor.debugLog("Monitoring thread interrupted");
                    break;
                }
                catch (Exception e) {
                    PotatoFileMonitor.debugLog("Error in monitoring thread: " + e.getMessage());
                }
            }
            PotatoFileMonitor.debugLog("Stopped potato.png monitoring thread");
        }, "PotatoFileMonitor");
        potatoMonitorThread.setDaemon(true);
        potatoMonitorThread.start();
    }

    public static void stopMonitoring() {
        if (!running) {
            return;
        }
        PotatoFileMonitor.debugLog("Stopping monitoring thread");
        running = false;
        if (potatoMonitorThread != null) {
            potatoMonitorThread.interrupt();
            try {
                potatoMonitorThread.join(2000L);
            }
            catch (InterruptedException e) {
                PotatoFileMonitor.debugLog("Interrupted while waiting for monitor thread to stop");
            }
            potatoMonitorThread = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean performPotatoCheck(Path shaderpackPath) {
        String potatoRelativePath = "shaders/lib/textures/potato.png";
        try {
            if (Files.isDirectory(shaderpackPath, new LinkOption[0])) {
                Path potatoPath = shaderpackPath.resolve(potatoRelativePath);
                return Files.exists(potatoPath, new LinkOption[0]);
            }
            if (Files.isRegularFile(shaderpackPath, new LinkOption[0]) && shaderpackPath.toString().toLowerCase(Locale.ROOT).endsWith(".zip")) {
                try (ZipFile zipFile = new ZipFile(shaderpackPath.toFile());){
                    ZipEntry entry = zipFile.getEntry(potatoRelativePath);
                    boolean exists = entry != null;
                    PotatoFileMonitor.debugLog("ZIP shaderpack: potato.png " + (exists ? "exists" : "does not exist"));
                    boolean bl = exists;
                    return bl;
                }
                catch (IOException e) {
                    PotatoFileMonitor.debugLog("Error reading ZIP file: " + e.getMessage());
                    return false;
                }
            }
            PotatoFileMonitor.debugLog("Shaderpack is neither a directory nor a ZIP file");
            return false;
        }
        catch (Exception e) {
            PotatoFileMonitor.debugLog("Exception checking for potato.png: " + e.getMessage());
            return false;
        }
    }

    public static void clearCache(String shaderpackPath) {
        if (potatoCache.remove(shaderpackPath) != null) {
            PotatoFileMonitor.debugLog("Cleared cache for " + shaderpackPath);
        }
    }

    public static void clearAllCache() {
        potatoCache.clear();
        currentShaderpackPath = null;
        lastKnownState = null;
        initialState = null;
        monitorLogCount.set(0);
        PotatoFileMonitor.debugLog("Cleared all cache");
    }

    public static boolean shouldAddPotatoRemovedDefine(Path shaderpackPath) {
        boolean potatoExists;
        if (shaderpackPath == null) {
            return false;
        }
        PotatoFileMonitor.setCurrentShaderpack(shaderpackPath);
        if (!running) {
            PotatoFileMonitor.startMonitoring();
        }
        return !(potatoExists = PotatoFileMonitor.checkPotatoExists(shaderpackPath));
    }
}

