/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.ArchiveUtils;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.euphoria_patcher.util.ShaderpacksWatcher;
import mc.euphoria_patches.euphoria_patcher.util.UpdateChecker;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.ArchiveException;

public class ArchiveOperations {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ArchiveOperations] " + message);
    }

    public static Path extract(Path source, Path targetDir, String operationName) {
        try {
            ArchiveOperations.debugLog("Extracting: " + source.getFileName() + " to " + targetDir);
            if (Files.isDirectory(source, new LinkOption[0])) {
                ArchiveOperations.debugLog("Source is already a directory, no extraction needed");
                return source;
            }
            ArchiveUtils.extract(source, targetDir);
            ArchiveOperations.debugLog("Extraction completed successfully");
            return targetDir;
        }
        catch (IOException | ArchiveException e) {
            ArchiveOperations.debugLog("Error " + operationName + ": " + e.getMessage());
            EuphoriaPatcher.log(2, "Error " + operationName + ": " + e.getMessage());
            return null;
        }
    }

    public static Path archive(Path source, Path targetArchive) {
        try {
            ArchiveOperations.debugLog("Archiving: " + source.getFileName() + " to " + targetArchive);
            ArchiveUtils.archive(source, targetArchive);
            ArchiveOperations.debugLog("Archiving completed successfully");
            return targetArchive;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error creating archive: " + e.getMessage());
            EuphoriaPatcher.log(2, "Error creating archive: " + e.getMessage());
            return null;
        }
    }

    public static boolean verifyBaseArchive(Path baseArchived, String originalFileName) {
        try {
            String fileName = baseArchived.getFileName().toString();
            ArchiveOperations.debugLog("Verifying archive: " + fileName);
            long fileSize = Files.size(baseArchived);
            if (EuphoriaPatcher.isDevFunc()) {
                EuphoriaPatcher.log(0, "Archive Name: " + fileName + " Archive size: " + fileSize + " bytes");
                String hash = ArchiveOperations.calculateSHA256(baseArchived);
                EuphoriaPatcher.log(0, "Archive SHA-256: " + hash);
            } else {
                boolean isValidSize;
                ArchiveOperations.debugLog("Archive size: " + fileSize + " bytes, expected: " + 1440768 + " bytes");
                boolean bl = isValidSize = fileSize == 1440768L;
                if (!isValidSize) {
                    ArchiveOperations.debugLog("Invalid archive size: verification failed");
                    if (EuphoriaPatcher.isNewerShaderVersion(fileName)) {
                        String detectedVersion = EuphoriaPatcher.getVersionStringFromFileName(fileName);
                        EuphoriaPatcher.log(3, 8, "=== VERSION MISMATCH ===");
                        EuphoriaPatcher.log(3, 8, "Found shader: " + originalFileName + " (version " + detectedVersion + ")");
                        EuphoriaPatcher.log(3, 8, "Required shader: ComplementaryShaders _r5.6.1");
                        EuphoriaPatcher.log(3, 8, "You have a NEWER shader version than what this mod version supports.");
                        if (UpdateChecker.isUpdateAvailable()) {
                            EuphoriaPatcher.log(3, 8, "");
                            EuphoriaPatcher.log(3, 8, "SOLUTION: Update EuphoriaPatches to the latest version: " + UpdateChecker.getNewModVersion());
                            EuphoriaPatcher.log(3, 8, "Download from: https://euphoriapatches.com/download");
                        } else {
                            EuphoriaPatcher.log(3, 8, "");
                            EuphoriaPatcher.log(3, 8, "SOLUTION 1: Wait for a EuphoriaPatches update that supports version " + detectedVersion);
                            EuphoriaPatcher.log(3, 8, "SOLUTION 2: Download the compatible shader version _r5.6.1");
                            EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
                        }
                    } else if (fileName.matches("Complementary.*_r5.6.1.*")) {
                        EuphoriaPatcher.log(3, 8, "=== FILE VERIFICATION FAILED ===");
                        EuphoriaPatcher.log(3, 8, "Shader file: " + originalFileName);
                        EuphoriaPatcher.log(3, 8, "This file appears to be incomplete or has been modified.");
                        EuphoriaPatcher.log(3, 8, "This can happen if the shader was manually edited or if it's from an unofficial source.");
                        EuphoriaPatcher.log(3, 8, "");
                        EuphoriaPatcher.log(3, 8, "SOLUTION: Re-download ComplementaryShaders _r5.6.1");
                        EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
                    } else {
                        EuphoriaPatcher.log(3, 8, "=== WRONG SHADER VERSION ===");
                        EuphoriaPatcher.log(3, 8, "Found: " + originalFileName);
                        EuphoriaPatcher.log(3, 8, "Required: ComplementaryShaders _r5.6.1");
                        EuphoriaPatcher.log(3, 8, "");
                        EuphoriaPatcher.log(3, 8, "SOLUTION: Download the correct shader version _r5.6.1");
                        EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
                    }
                    EuphoriaPatcher.log(0, "Watching for the correct shader to be added...");
                    EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                    if (instance != null) {
                        instance.startWatcherAfterByteSizeFailure();
                        ShaderpacksWatcher watcher = instance.getShaderpacksWatcher();
                        if (watcher != null) {
                            watcher.trackInvalidByteSizeFile(fileName);
                        }
                    }
                    return false;
                }
                if (ArchiveOperations.isTestOrDevVersion(fileName)) {
                    ArchiveOperations.debugLog("Test/fix version detected: " + originalFileName);
                    EuphoriaPatcher.log(3, 8, "=== DEV VERSION DETECTED ===");
                    EuphoriaPatcher.log(3, 8, "Found: " + originalFileName);
                    EuphoriaPatcher.log(3, 8, "This appears to be a test, dev, or pre-release version.");
                    EuphoriaPatcher.log(3, 8, "");
                    EuphoriaPatcher.log(3, 8, "SOLUTION: Download the official Complementary release version: _r5.6.1");
                    EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
                    EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                    if (instance != null) {
                        instance.startWatcherAfterByteSizeFailure();
                        ShaderpacksWatcher watcher = instance.getShaderpacksWatcher();
                        if (watcher != null) {
                            watcher.trackInvalidByteSizeFile(fileName);
                        }
                    }
                    return false;
                }
                if (ArchiveOperations.detectIncorrectHash(baseArchived)) {
                    ArchiveOperations.debugLog("Archive hash verification failed - file has been modified");
                    EuphoriaPatcher.log(3, 8, "=== FILE VERIFICATION FAILED ===");
                    EuphoriaPatcher.log(3, 8, "Shader file: " + originalFileName);
                    EuphoriaPatcher.log(3, 8, "This file appears to have been modified.");
                    EuphoriaPatcher.log(3, 8, "This can happen if the shader was manually edited or if it's from an unofficial source.");
                    EuphoriaPatcher.log(3, 8, "File size matches but content hash does not.");
                    EuphoriaPatcher.log(3, 8, "");
                    EuphoriaPatcher.log(3, 8, "SOLUTION: Download the original unmodified Complementary shader");
                    EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
                    EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                    if (instance != null) {
                        instance.startWatcherAfterByteSizeFailure();
                        ShaderpacksWatcher watcher = instance.getShaderpacksWatcher();
                        if (watcher != null) {
                            watcher.trackInvalidByteSizeFile(fileName);
                        }
                    }
                    return false;
                }
                ArchiveOperations.debugLog("Archive size and hash verification passed");
            }
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error during archive verification: " + e.getMessage());
            EuphoriaPatcher.log(3, "Something went wrong during the file verification: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static String calculateSHA256(Path filePath) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] fileBytes = Files.readAllBytes(filePath);
            byte[] hashBytes = digest.digest(fileBytes);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            ArchiveOperations.debugLog("Error calculating SHA-256: " + e.getMessage());
            return null;
        }
    }

    private static boolean detectIncorrectHash(Path archivePath) {
        String expectedHash = "85bedae6a1fc8cac5f24cbcca18950f850dc7867c30e7db2bb0e15cb63729fe5";
        String actualHash = ArchiveOperations.calculateSHA256(archivePath);
        if (actualHash == null) {
            return true;
        }
        boolean hashMatches = expectedHash.equals(actualHash);
        ArchiveOperations.debugLog("Hash verification - Expected: " + expectedHash);
        ArchiveOperations.debugLog("Hash verification - Actual:   " + actualHash);
        ArchiveOperations.debugLog("Hash verification - Match: " + hashMatches);
        return !hashMatches;
    }

    private static boolean isTestOrDevVersion(String fileName) {
        String fileNameLower = fileName.toLowerCase(Locale.ROOT);
        return fileNameLower.contains("test") || fileNameLower.contains("fix") || fileNameLower.contains("dev") || fileNameLower.contains("pre");
    }

    public static boolean verifyBaseArchiveQuiet(Path baseArchived) {
        try {
            String fileName = baseArchived.getFileName().toString();
            ArchiveOperations.debugLog("Quietly verifying archive: " + fileName);
            if (EuphoriaPatcher.isDevFunc()) {
                ArchiveOperations.debugLog("Dev mode: bypassing verification (returning true)");
            } else {
                long fileSize = Files.size(baseArchived);
                boolean isValidSize = fileSize == 1440768L;
                ArchiveOperations.debugLog("Archive size: " + fileSize + " bytes, expected: " + 1440768 + " bytes, valid: " + isValidSize);
                if (!isValidSize) {
                    return false;
                }
                if (ArchiveOperations.isTestOrDevVersion(fileName)) {
                    ArchiveOperations.debugLog("Test/fix version detected in quiet check: " + fileName);
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error during quiet archive verification: " + e.getMessage());
            return false;
        }
    }
}

