/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.alllootdrops_common_forge.events;

import com.natamus.alllootdrops_common_forge.config.ConfigHandler;
import com.natamus.alllootdrops_common_forge.data.Constants;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntityDroppingEvent {
    public static void onWorldLoad(ServerLevel level) {
        if (GlobalVariables.entitydrops != null) {
            return;
        }
        ItemFunctions.generateEntityDropsFromLootTable((Level)level);
    }

    public static void mobItemDrop(Level level, Entity entity, DamageSource damageSource) {
        Entity source;
        EntityType type;
        if (level.isClientSide()) {
            return;
        }
        if (entity instanceof Player || !(entity instanceof LivingEntity)) {
            return;
        }
        if (entity instanceof MagmaCube && damageSource.getEntity() instanceof Frog) {
            return;
        }
        if (GlobalVariables.entitydrops == null) {
            Constants.logger.warn("[All Loot Drops] Error: Unable to find generated loot drops. Attempting to generate them now.");
            ItemFunctions.generateEntityDropsFromLootTable((Level)level);
            if (GlobalVariables.entitydrops == null) {
                Constants.logger.warn("[All Loot Drops] Error: Still unable to generate loot drops. Please submit a bug report at 'https://github.com/ricksouth/serilum-mc-mods/labels/Mod:%20All%20Loot%20Drops'.");
                return;
            }
        }
        if (!GlobalVariables.entitydrops.containsKey(type = entity.getType())) {
            return;
        }
        ArrayList alldrops = new ArrayList((Collection)GlobalVariables.entitydrops.get(type));
        int amount = ConfigHandler.lootQuantity;
        if (ConfigHandler.lootingEnchantAffectsQuantity && (source = damageSource.getEntity()) instanceof Player) {
            int lootinglevel = EnchantmentHelper.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOOTING), (LivingEntity)((LivingEntity)source));
            double increasechance = ConfigHandler.lootingEnchantExtraQuantityChance;
            for (int n = 0; n < lootinglevel; ++n) {
                double num = GlobalVariables.random.nextDouble();
                if (!(num <= increasechance)) continue;
                ++amount;
            }
        }
        BlockPos epos = entity.blockPosition();
        int finalAmount = amount;
        TaskFunctions.enqueueTask((Level)level, () -> {
            ArrayList<ItemEntity> dropEntities = new ArrayList<ItemEntity>();
            for (Entity ea : level.getEntities(null, new AABB((double)(epos.getX() - 1), (double)(epos.getY() - 1), (double)(epos.getZ() - 1), (double)(epos.getX() + 1), (double)(epos.getY() + 1), (double)(epos.getZ() + 1)))) {
                int tickCount;
                if (!(ea instanceof ItemEntity) || (tickCount = ea.tickCount) > 1) continue;
                dropEntities.add((ItemEntity)ea);
            }
            ArrayList<ItemEntity> tr = new ArrayList<ItemEntity>();
            for (ItemEntity ie : dropEntities) {
                ItemStack stack = ie.getItem();
                Item item = stack.getItem();
                if (!alldrops.contains(item)) continue;
                tr.add(ie);
            }
            if (tr.size() > 0) {
                for (ItemEntity ie : tr) {
                    ItemStack ieitemstack = ie.getItem();
                    if (ConfigHandler.keepOriginalLootQuantityIfHigher && ieitemstack.getCount() > ConfigHandler.lootQuantity) {
                        alldrops.remove(ieitemstack.getItem());
                        continue;
                    }
                    ie.remove(Entity.RemovalReason.DISCARDED);
                }
            }
            for (Item item : alldrops) {
                ItemEntity ie = new ItemEntity(level, (double)epos.getX(), (double)(epos.getY() + 1), (double)epos.getZ(), new ItemStack((ItemLike)item, finalAmount));
                level.addFreshEntity((Entity)ie);
            }
        }, (int)0);
    }
}

