/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.fabric;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.clientMapHandlers.MapHighlightClearer;
import de.the_build_craft.maplink.common.clientMapHandlers.XaeroClientMapHandler;
import de.the_build_craft.maplink.common.waypoints.AreaMarker;
import de.the_build_craft.maplink.common.waypoints.Color;
import de.the_build_craft.maplink.common.waypoints.MathUtils;
import de.the_build_craft.maplink.common.wrappers.Text;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import xaero.map.WorldMapSession;
import xaero.map.highlight.ChunkHighlighter;
import xaero.map.world.MapDimension;

public class AreaMarkerHighlighter
extends ChunkHighlighter
implements MapHighlightClearer {
    public AreaMarkerHighlighter() {
        super(true);
        XaeroClientMapHandler.mapHighlightClearer = this;
    }

    @Override
    public void clearHashCache() {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        try {
            MapDimension mapDim = WorldMapSession.getCurrentSession().getMapProcessor().getMapWorld().getDimension(class_310.method_1551().field_1687.method_27983());
            if (mapDim != null) {
                mapDim.getHighlightHandler().clearCachedHashes();
            }
        }
        catch (NullPointerException mapDim) {
        }
        catch (Exception e) {
            AbstractModInitializer.LOGGER.error("Could not clear Xaero Highlight Hash!", (Throwable)e);
        }
    }

    private List<Set<AreaMarker>> getDirections(int chunkX, int chunkZ) {
        if (XaeroClientMapHandler.currentlyRasterising) {
            return null;
        }
        Set areaMarkerSet = (Set)XaeroClientMapHandler.chunkHighlightMap.get(MathUtils.combineIntsToLong(chunkX, chunkZ));
        if (areaMarkerSet == null) {
            return null;
        }
        Set top = (Set)XaeroClientMapHandler.chunkHighlightMap.getOrDefault(MathUtils.combineIntsToLong(chunkX, chunkZ - 1), Collections.emptySet());
        Set bottom = (Set)XaeroClientMapHandler.chunkHighlightMap.getOrDefault(MathUtils.combineIntsToLong(chunkX, chunkZ + 1), Collections.emptySet());
        Set left = (Set)XaeroClientMapHandler.chunkHighlightMap.getOrDefault(MathUtils.combineIntsToLong(chunkX - 1, chunkZ), Collections.emptySet());
        Set right = (Set)XaeroClientMapHandler.chunkHighlightMap.getOrDefault(MathUtils.combineIntsToLong(chunkX + 1, chunkZ), Collections.emptySet());
        return Arrays.asList(areaMarkerSet, top, right, bottom, left);
    }

    protected int[] getColors(class_5321<class_1937> dimension, int chunkX, int chunkZ) {
        List<Set<AreaMarker>> directions = this.getDirections(chunkX, chunkZ);
        if (directions == null) {
            return null;
        }
        Set<AreaMarker> areaMarkerSet = directions.get(0);
        int fillColor = Color.combineColors(areaMarkerSet.stream().map(a -> a.fillColor).collect(Collectors.toList()), (float)CommonModConfig.config.general.areaFillAlphaMul / 100.0f, (float)CommonModConfig.config.general.areaFillAlphaMin / 100.0f, (float)CommonModConfig.config.general.areaFillAlphaMax / 100.0f).getAsBGRA();
        int[] colors = new int[5];
        colors[0] = fillColor;
        for (int i = 1; i < directions.size(); ++i) {
            Set<AreaMarker> direction = directions.get(i);
            List<Color> lineColors = areaMarkerSet.stream().filter(a -> !direction.contains(a)).map(a -> a.lineColor).collect(Collectors.toList());
            colors[i] = lineColors.isEmpty() ? fillColor : Color.combineColors(lineColors, (float)CommonModConfig.config.general.areaLineAlphaMul / 100.0f, (float)CommonModConfig.config.general.areaLineAlphaMin / 100.0f, (float)CommonModConfig.config.general.areaLineAlphaMax / 100.0f).getAsBGRA();
        }
        return colors;
    }

    public class_2561 getChunkHighlightTooltip(int chunkX, int chunkZ, Function<AreaMarker, String> toName) {
        List<Set<AreaMarker>> directions = this.getDirections(chunkX, chunkZ);
        if (directions == null) {
            return null;
        }
        Set<AreaMarker> areaMarkerSet = directions.get(0);
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 1; i < directions.size(); ++i) {
            Set<AreaMarker> direction = directions.get(i);
            areaMarkerSet.stream().filter(a -> !direction.contains(a)).map(toName).forEach(names::add);
        }
        for (AreaMarker areaMarker : areaMarkerSet) {
            if (!(class_3532.method_15363((float)(areaMarker.fillColor.a * ((float)CommonModConfig.config.general.areaFillAlphaMul / 100.0f)), (float)((float)CommonModConfig.config.general.areaFillAlphaMin / 100.0f), (float)((float)CommonModConfig.config.general.areaFillAlphaMax / 100.0f)) > 0.0f)) continue;
            names.add(toName.apply(areaMarker));
        }
        if (names.isEmpty()) {
            return null;
        }
        return Text.literal(String.join((CharSequence)" | ", names));
    }

    public class_2561 getChunkHighlightSubtleTooltip(class_5321<class_1937> dimension, int chunkX, int chunkZ) {
        return this.getChunkHighlightTooltip(chunkX, chunkZ, areaMarker -> areaMarker.layer.name);
    }

    public class_2561 getChunkHighlightBluntTooltip(class_5321<class_1937> dimension, int chunkX, int chunkZ) {
        return this.getChunkHighlightTooltip(chunkX, chunkZ, areaMarker -> areaMarker.name);
    }

    public int calculateRegionHash(class_5321<class_1937> dimension, int regionX, int regionZ) {
        return 1 + XaeroClientMapHandler.chunkHighlightHash;
    }

    public boolean regionHasHighlights(class_5321<class_1937> dimension, int regionX, int regionZ) {
        if (XaeroClientMapHandler.currentlyRasterising) {
            return false;
        }
        return XaeroClientMapHandler.regionsWithChunkHighlights.contains(MathUtils.combineIntsToLong(regionX, regionZ));
    }

    public boolean chunkIsHighlit(class_5321<class_1937> dimension, int chunkX, int chunkZ) {
        List<Set<AreaMarker>> directions = this.getDirections(chunkX, chunkZ);
        if (directions == null) {
            return false;
        }
        Set<AreaMarker> areaMarkerSet = directions.get(0);
        for (AreaMarker areaMarker : areaMarkerSet) {
            if (!(class_3532.method_15363((float)(areaMarker.fillColor.a * ((float)CommonModConfig.config.general.areaFillAlphaMul / 100.0f)), (float)((float)CommonModConfig.config.general.areaFillAlphaMin / 100.0f), (float)((float)CommonModConfig.config.general.areaFillAlphaMax / 100.0f)) > 0.0f)) continue;
            return true;
        }
        for (int i = 1; i < directions.size(); ++i) {
            Set<AreaMarker> direction = directions.get(i);
            if (!areaMarkerSet.stream().anyMatch(a -> !direction.contains(a))) continue;
            return true;
        }
        return false;
    }

    public void addMinimapBlockHighlightTooltips(List<class_2561> list, class_5321<class_1937> dimension, int blockX, int blockZ, int width) {
    }
}

