/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.clientMapHandlers;

import com.mojang.blaze3d.textures.GpuTexture;
import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.FastUpdateTask;
import de.the_build_craft.maplink.common.MainThreadTaskQueue;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.clientMapHandlers.MapHighlightClearer;
import de.the_build_craft.maplink.common.waypoints.AreaMarker;
import de.the_build_craft.maplink.common.waypoints.CustomWorldMapWaypoint;
import de.the_build_craft.maplink.common.waypoints.FixedWaypoint;
import de.the_build_craft.maplink.common.waypoints.Int3;
import de.the_build_craft.maplink.common.waypoints.MathUtils;
import de.the_build_craft.maplink.common.waypoints.MutablePlayerPosition;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.waypoints.PlayerWaypoint;
import de.the_build_craft.maplink.common.waypoints.Position;
import de.the_build_craft.maplink.common.waypoints.TempWaypoint;
import de.the_build_craft.maplink.common.waypoints.WaypointState;
import de.the_build_craft.maplink.mixins.common.mods.xaeroworldmap.WorldMapWaypointAccessor;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1043;
import net.minecraft.class_640;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.mods.gui.Waypoint;

public class XaeroClientMapHandler
extends ClientMapHandler {
    public static final Long2ObjectMap<Set<AreaMarker>> chunkHighlightMap = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    public static final LongSet regionsWithChunkHighlights = LongSets.synchronize((LongSet)new LongOpenHashSet());
    public static int chunkHighlightHash;
    public static boolean currentlyRasterising;
    public static MapHighlightClearer mapHighlightClearer;
    private static final Map<String, XaeroIcon> iconLinkToXaeroIcon;
    public static final Map<String, TempWaypoint> idToHudPlayer;
    public static final Map<String, TempWaypoint> idToMiniMapPlayer;
    public static final Map<String, Waypoint> idToWorldMapPlayer;
    public static final Map<String, TempWaypoint> idToHudMarker;
    public static final Map<String, TempWaypoint> idToMiniMapMarker;
    public static final Map<String, Waypoint> idToWorldMapMarker;
    public static final Map<UUID, MutablePlayerPosition> hudAndMinimapPlayerTrackerPositions;
    public static final Map<UUID, MutablePlayerPosition> worldmapPlayerTrackerPositions;
    private final Set<UUID> currentHudAndMinimapPlayerTrackerUUIDs = new HashSet<UUID>();
    private final Set<UUID> currentWorldmapPlayerTrackerUUIDs = new HashSet<UUID>();
    private final Map<String, MainThreadTaskQueue.QueuedTask<Void>> queuedTaskMap = new ConcurrentHashMap<String, MainThreadTaskQueue.QueuedTask<Void>>();
    private boolean hasAreaMarkers = true;
    private Thread currentRasterThread;

    @Override
    public void reset() {
        this.removeAllPlayerWaypoints();
        this.removeAllMarkerWaypoints();
        this.removeAllAreaMarkers(true);
        hudAndMinimapPlayerTrackerPositions.clear();
        worldmapPlayerTrackerPositions.clear();
        Iterator<Map.Entry<String, MainThreadTaskQueue.QueuedTask<Void>>> queuedTaskIterator = this.queuedTaskMap.entrySet().iterator();
        while (queuedTaskIterator.hasNext()) {
            Map.Entry<String, MainThreadTaskQueue.QueuedTask<Void>> queuedTaskEntry = queuedTaskIterator.next();
            if (queuedTaskEntry != null) {
                queuedTaskEntry.getValue().cancel();
            }
            queuedTaskIterator.remove();
        }
    }

    @Override
    public void handlePlayerWaypoints() {
        super.handlePlayerWaypoints();
        if (CommonModConfig.config.general.enablePlayerWaypoints && CommonModConfig.config.general.showPlayerWaypointsAsTrackedPlayers && this.mc.method_1562() != null) {
            this.currentHudAndMinimapPlayerTrackerUUIDs.clear();
            this.currentWorldmapPlayerTrackerUUIDs.clear();
            for (class_640 playerInfo : this.mc.method_1562().method_2880()) {
                String playerName = playerInfo.method_2966().name();
                UUID id = playerInfo.method_2966().id();
                PlayerPosition playerPosition = FastUpdateTask.playerPositions.get(playerName);
                if (playerPosition == null || !this.currentPlayerIds.contains(playerPosition.id)) continue;
                WaypointState waypointState = XaeroClientMapHandler.getWaypointState(playerPosition.id);
                playerPosition.gameProfile = playerInfo.method_2966();
                if (waypointState.renderOnHud || waypointState.renderOnMiniMap) {
                    hudAndMinimapPlayerTrackerPositions.computeIfAbsent(id, uuid -> new MutablePlayerPosition(playerPosition, waypointState)).updateFrom(playerPosition.pos);
                    this.currentHudAndMinimapPlayerTrackerUUIDs.add(id);
                }
                if (!waypointState.renderOnWorldMap) continue;
                worldmapPlayerTrackerPositions.computeIfAbsent(id, uuid -> new MutablePlayerPosition(playerPosition, waypointState)).updateFrom(playerPosition.pos);
                this.currentWorldmapPlayerTrackerUUIDs.add(id);
            }
            hudAndMinimapPlayerTrackerPositions.keySet().removeIf(p -> !this.currentHudAndMinimapPlayerTrackerUUIDs.contains(p));
            worldmapPlayerTrackerPositions.keySet().removeIf(p -> !this.currentWorldmapPlayerTrackerUUIDs.contains(p));
        } else {
            hudAndMinimapPlayerTrackerPositions.clear();
            worldmapPlayerTrackerPositions.clear();
        }
    }

    @Override
    void addOrUpdatePlayerWaypoint(PlayerPosition playerPosition, WaypointState waypointState) {
        if (waypointState.renderOnHud) {
            this.addOrUpdateMiniMapWaypoint(playerPosition, idToHudPlayer, player -> new PlayerWaypoint((PlayerPosition)player, waypointState));
        }
        if (waypointState.renderOnMiniMap) {
            this.addOrUpdateMiniMapWaypoint(playerPosition, idToMiniMapPlayer, player -> new PlayerWaypoint((PlayerPosition)player, waypointState));
        }
        if (waypointState.renderOnWorldMap) {
            this.addOrUpdateWorldMapWaypoint(playerPosition, idToWorldMapPlayer, player -> new PlayerWaypoint((PlayerPosition)player, waypointState));
        }
    }

    private <P extends Position> void addOrUpdateMiniMapWaypoint(P position, Map<String, TempWaypoint> idToWaypoint, Function<P, TempWaypoint> waypointInit) {
        xaero.common.minimap.waypoints.Waypoint w;
        if (!AbstractModInitializer.connected) {
            return;
        }
        MainThreadTaskQueue.QueuedTask<Void> queuedTask = this.queuedTaskMap.get(position.id);
        if (queuedTask != null) {
            if (queuedTask.future.isDone()) {
                this.queuedTaskMap.remove(position.id);
            } else {
                queuedTask.future.thenRun(() -> {
                    xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)idToWaypoint.get(position.id);
                    if (w != null) {
                        Int3 pos = position.pos.floorToInt3();
                        w.setX(pos.x);
                        w.setY(pos.y);
                        w.setZ(pos.z);
                    }
                });
                return;
            }
        }
        if ((w = (xaero.common.minimap.waypoints.Waypoint)idToWaypoint.get(position.id)) != null) {
            Int3 pos = position.pos.floorToInt3();
            w.setX(pos.x);
            w.setY(pos.y);
            w.setZ(pos.z);
        } else {
            this.queuedTaskMap.put(position.id, MainThreadTaskQueue.queueTask(() -> idToWaypoint.put(position.id, (TempWaypoint)((Object)((Object)waypointInit.apply(position))))));
        }
    }

    private <P extends Position> void addOrUpdateWorldMapWaypoint(P position, Map<String, Waypoint> idToWaypoint, Function<P, TempWaypoint> waypointInit) {
        WorldMapWaypointAccessor w;
        if (!AbstractModInitializer.connected) {
            return;
        }
        MainThreadTaskQueue.QueuedTask<Void> queuedTask = this.queuedTaskMap.get(position.id);
        if (queuedTask != null) {
            if (queuedTask.future.isDone()) {
                this.queuedTaskMap.remove(position.id);
            } else {
                queuedTask.future.thenRun(() -> {
                    WorldMapWaypointAccessor w = (WorldMapWaypointAccessor)idToWaypoint.get(position.id);
                    if (w != null) {
                        Int3 pos = position.pos.floorToInt3();
                        w.setX(pos.x);
                        w.setY(pos.y);
                        w.setZ(pos.z);
                    }
                });
                return;
            }
        }
        if ((w = (WorldMapWaypointAccessor)idToWaypoint.get(position.id)) != null) {
            Int3 pos = position.pos.floorToInt3();
            w.setX(pos.x);
            w.setY(pos.y);
            w.setZ(pos.z);
        } else {
            this.queuedTaskMap.put(position.id, MainThreadTaskQueue.queueTask(() -> idToWaypoint.put(position.id, new CustomWorldMapWaypoint((TempWaypoint)((Object)((Object)waypointInit.apply(position)))))));
        }
    }

    private <W> void removeOldWaypointsFromMap(Map<String, W> map, Predicate<WaypointState> removeIf, Set<String> idHasToBeIn) {
        Iterator<Map.Entry<String, W>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, W> entry = iterator.next();
            WaypointState waypointState = ClientMapHandler.getWaypointState(entry.getKey());
            if (waypointState != null && (!waypointState.isPlayer || !CommonModConfig.config.general.showPlayerWaypointsAsTrackedPlayers) && !removeIf.test(waypointState) && idHasToBeIn.contains(entry.getKey())) continue;
            iterator.remove();
        }
    }

    @Override
    void removeOldPlayerWaypoints() {
        this.removeOldWaypointsFromMap(idToHudPlayer, w -> !w.renderOnHud, this.currentPlayerIds);
        this.removeOldWaypointsFromMap(idToMiniMapPlayer, w -> !w.renderOnMiniMap, this.currentPlayerIds);
        this.removeOldWaypointsFromMap(idToWorldMapPlayer, w -> !w.renderOnWorldMap, this.currentPlayerIds);
    }

    @Override
    void removeAllPlayerWaypoints() {
        idToHudPlayer.clear();
        idToMiniMapPlayer.clear();
        idToWorldMapPlayer.clear();
    }

    private void updateMiniMapWaypointColors(Map<String, TempWaypoint> map, Function<TempWaypoint, Integer> waypointToColor) {
        for (TempWaypoint waypoint : map.values()) {
            waypoint.setWaypointColor(WaypointColor.fromIndex((int)waypointToColor.apply(waypoint)));
        }
    }

    private void updateWorldMapWaypointColors(Map<String, Waypoint> map, Function<Waypoint, Integer> waypointToColor) {
        for (Waypoint waypoint : map.values()) {
            ((WorldMapWaypointAccessor)waypoint).setColor(WaypointColor.fromIndex((int)waypointToColor.apply(waypoint)).getHex());
        }
    }

    @Override
    void updatePlayerWaypointColors() {
        this.updateMiniMapWaypointColors(idToHudPlayer, w -> CommonModConfig.getPlayerWaypointColor(w.getName()));
        this.updateMiniMapWaypointColors(idToMiniMapPlayer, w -> CommonModConfig.getPlayerWaypointColor(w.getName()));
        this.updateWorldMapWaypointColors(idToWorldMapPlayer, w -> CommonModConfig.getPlayerWaypointColor(w.getName()));
    }

    @Override
    void addOrUpdateMarkerWaypoint(Position markerPosition, WaypointState waypointState) {
        if (waypointState.renderOnHud) {
            this.addOrUpdateMiniMapWaypoint(markerPosition, idToHudMarker, p -> new FixedWaypoint((Position)p, waypointState));
        }
        if (waypointState.renderOnMiniMap) {
            this.addOrUpdateMiniMapWaypoint(markerPosition, idToMiniMapMarker, p -> new FixedWaypoint((Position)p, waypointState));
        }
        if (waypointState.renderOnWorldMap) {
            this.addOrUpdateWorldMapWaypoint(markerPosition, idToWorldMapMarker, p -> new FixedWaypoint((Position)p, waypointState));
        }
    }

    @Override
    void removeOldMarkerWaypoints() {
        this.removeOldWaypointsFromMap(idToHudMarker, w -> !w.renderOnHud, this.currentMarkerIds);
        this.removeOldWaypointsFromMap(idToMiniMapMarker, w -> !w.renderOnMiniMap, this.currentMarkerIds);
        this.removeOldWaypointsFromMap(idToWorldMapMarker, w -> !w.renderOnWorldMap, this.currentMarkerIds);
    }

    @Override
    public void removeAllMarkerWaypoints() {
        idToHudMarker.clear();
        idToMiniMapMarker.clear();
        idToWorldMapMarker.clear();
    }

    @Override
    void updateMarkerWaypointColors() {
        this.updateMiniMapWaypointColors(idToHudMarker, w -> CommonModConfig.config.general.markerWaypointColor.ordinal());
        this.updateMiniMapWaypointColors(idToMiniMapMarker, w -> CommonModConfig.config.general.markerWaypointColor.ordinal());
        this.updateWorldMapWaypointColors(idToWorldMapMarker, w -> CommonModConfig.config.general.markerWaypointColor.ordinal());
    }

    @Override
    public void handleAreaMarkers(List<AreaMarker> markerPositions) {
        currentlyRasterising = false;
        if (this.currentRasterThread != null) {
            try {
                this.currentRasterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.currentRasterThread = null;
        }
        this.removeAllAreaMarkers(false);
        if (CommonModConfig.config.general.enableAreaMarkerOverlay) {
            currentlyRasterising = true;
            this.currentRasterThread = new Thread(() -> {
                for (Map.Entry<AreaMarker, List> cords : markerPositions.parallelStream().collect(Collectors.toMap(a -> a, this::rasterizeAreaMarker)).entrySet()) {
                    Iterator iterator = cords.getValue().iterator();
                    while (iterator.hasNext()) {
                        long cord = (Long)iterator.next();
                        if (!currentlyRasterising) {
                            return;
                        }
                        this.createChunkHighlightAt(cords.getKey(), cord);
                    }
                }
                if (!currentlyRasterising) {
                    return;
                }
                chunkHighlightHash = (chunkHighlightHash + 1) % 10000;
                if (mapHighlightClearer != null) {
                    mapHighlightClearer.clearHashCache();
                }
                currentlyRasterising = false;
            });
            this.currentRasterThread.start();
        } else {
            chunkHighlightHash = (chunkHighlightHash + 1) % 10000;
            if (mapHighlightClearer != null) {
                mapHighlightClearer.clearHashCache();
            }
        }
    }

    private void createChunkHighlightAt(AreaMarker areaMarker, long chunkKey) {
        this.hasAreaMarkers = true;
        ((Set)chunkHighlightMap.computeIfAbsent(chunkKey, key -> new HashSet())).add(areaMarker);
        regionsWithChunkHighlights.add(MathUtils.shiftRightIntsInLong(chunkKey, 5));
    }

    @Override
    public void removeAllAreaMarkers(boolean clearXaeroHash) {
        this.hasAreaMarkers = this.hasAreaMarkers || !chunkHighlightMap.isEmpty() || !regionsWithChunkHighlights.isEmpty();
        chunkHighlightMap.clear();
        regionsWithChunkHighlights.clear();
        currentlyRasterising = false;
        if (clearXaeroHash && this.hasAreaMarkers && mapHighlightClearer != null) {
            chunkHighlightHash = (chunkHighlightHash + 1) % 10000;
            mapHighlightClearer.clearHashCache();
            this.hasAreaMarkers = false;
        }
    }

    List<Long> rasterizeAreaMarker(AreaMarker areaMarker) {
        try {
            if (areaMarker.polygons.length == 0) {
                return new ArrayList<Long>();
            }
            Int3[][] polygons = (Int3[][])Arrays.stream(areaMarker.polygons).toArray(x$0 -> new Int3[x$0][]);
            ArrayList edges = new ArrayList();
            ArrayList<Long> additionalChunks = new ArrayList<Long>();
            ArrayList<Edge> tempEdges = new ArrayList<Edge>();
            int area = 0;
            for (Int3[] polygon : polygons) {
                tempEdges.clear();
                int globalXMin = Integer.MAX_VALUE;
                int globalXMax = Integer.MIN_VALUE;
                int globalZMin = Integer.MAX_VALUE;
                int globalZMax = Integer.MIN_VALUE;
                for (int i = 0; i < polygon.length; ++i) {
                    Int3 point = polygon[i];
                    Int3 otherPoint = polygon[(i + 1) % polygon.length];
                    globalXMin = Math.min(globalXMin, point.x);
                    globalXMax = Math.max(globalXMax, point.x);
                    globalZMin = Math.min(globalZMin, point.z);
                    globalZMax = Math.max(globalZMax, point.z);
                    if (point.z == otherPoint.z) continue;
                    tempEdges.add(new Edge(point, otherPoint));
                }
                if ((area += (1 + (globalXMax >>= 4) - (globalXMin >>= 4)) * (1 + (globalZMax >>= 4) - (globalZMin >>= 4))) > CommonModConfig.config.general.maxChunkArea) {
                    return new ArrayList<Long>();
                }
                if (globalXMin == globalXMax) {
                    for (int z = globalZMin; z <= globalZMax; ++z) {
                        additionalChunks.add(MathUtils.combineIntsToLong(globalXMin, z));
                    }
                    continue;
                }
                if (globalZMin == globalZMax) {
                    for (int x = globalXMin; x <= globalXMax; ++x) {
                        additionalChunks.add(MathUtils.combineIntsToLong(x, globalZMin));
                    }
                    continue;
                }
                edges.addAll(tempEdges);
            }
            if (edges.isEmpty()) {
                return additionalChunks;
            }
            Long2IntOpenHashMap result = new Long2IntOpenHashMap(area);
            Collections.sort(edges);
            int z = ((Edge)edges.get((int)0)).zMin;
            ArrayList<Edge> activeEdges = new ArrayList<Edge>();
            ArrayList<Integer> intersections = new ArrayList<Integer>();
            while (!edges.isEmpty() || !activeEdges.isEmpty()) {
                if (!currentlyRasterising) {
                    return new ArrayList<Long>();
                }
                Iterator edgeIterator = edges.iterator();
                while (edgeIterator.hasNext()) {
                    Edge edge = (Edge)edgeIterator.next();
                    if (edge.zMin != z) break;
                    activeEdges.add(edge);
                    edgeIterator.remove();
                }
                activeEdges.sort(Comparator.comparing(e -> Float.valueOf(e.xHit)));
                intersections.clear();
                for (Edge e2 : activeEdges) {
                    if (e2.zMax == z) continue;
                    intersections.add(Math.round(e2.xHit));
                }
                if (intersections.size() % 2 == 0) {
                    for (int i = 0; i < intersections.size() - 1; i += 2) {
                        int xMin = (Integer)intersections.get(i);
                        int xMax = (Integer)intersections.get(i + 1);
                        for (int x = xMin; x <= xMax; ++x) {
                            if (!currentlyRasterising) {
                                return new ArrayList<Long>();
                            }
                            long key = MathUtils.combineIntsToLong(x >> 4, z >> 4);
                            result.put(key, result.get(key) + 1);
                        }
                    }
                } else {
                    AbstractModInitializer.LOGGER.error("error in polygon rasterization: " + areaMarker.name);
                    return new ArrayList<Long>();
                }
                edgeIterator = activeEdges.iterator();
                while (edgeIterator.hasNext()) {
                    Edge e3 = (Edge)edgeIterator.next();
                    if (e3.zMax == z) {
                        edgeIterator.remove();
                        continue;
                    }
                    e3.xHit += e3.mInv;
                }
                ++z;
            }
            List<Long> resultList = result.long2IntEntrySet().stream().filter(entry -> entry.getIntValue() >= CommonModConfig.config.general.blocksPerChunkThreshold).map(Long2IntMap.Entry::getLongKey).collect(Collectors.toList());
            resultList.addAll(additionalChunks);
            return resultList;
        }
        catch (Throwable t) {
            AbstractModInitializer.LOGGER.error("unexpected error in polygon rasterization", t);
            return new ArrayList<Long>();
        }
    }

    public static XaeroIcon getXaeroIcon(String link) {
        if (iconLinkToXaeroIcon.containsKey(link)) {
            return iconLinkToXaeroIcon.get(link);
        }
        class_1043 dynamicTexture = XaeroClientMapHandler.getDynamicTexture(link);
        if (dynamicTexture == null) {
            return null;
        }
        GpuTexture texture = dynamicTexture.method_68004();
        XaeroIcon icon = XaeroIconAtlas.Builder.begin().setPreparedTexture(texture).setIconWidth(texture.getWidth(0)).setWidth(texture.getWidth(0)).build().createIcon();
        iconLinkToXaeroIcon.put(link, icon);
        return icon;
    }

    static {
        iconLinkToXaeroIcon = new HashMap<String, XaeroIcon>();
        idToHudPlayer = new ConcurrentHashMap<String, TempWaypoint>();
        idToMiniMapPlayer = new ConcurrentHashMap<String, TempWaypoint>();
        idToWorldMapPlayer = new ConcurrentHashMap<String, Waypoint>();
        idToHudMarker = new ConcurrentHashMap<String, TempWaypoint>();
        idToMiniMapMarker = new ConcurrentHashMap<String, TempWaypoint>();
        idToWorldMapMarker = new ConcurrentHashMap<String, Waypoint>();
        hudAndMinimapPlayerTrackerPositions = new ConcurrentHashMap<UUID, MutablePlayerPosition>();
        worldmapPlayerTrackerPositions = new ConcurrentHashMap<UUID, MutablePlayerPosition>();
    }

    static class Edge
    implements Comparable<Edge> {
        int zMin;
        int zMax;
        float xHit;
        float mInv;
        int xMin;
        int xMax;

        public Edge(Int3 a, Int3 b) {
            this.zMin = Math.min(a.z, b.z);
            this.zMax = Math.max(a.z, b.z);
            this.xHit = this.zMin == a.z ? (float)a.x : (float)b.x;
            this.mInv = (float)(b.x - a.x) / (float)(b.z - a.z);
            this.xMin = Math.min(a.x, b.x);
            this.xMax = Math.max(a.x, b.x);
        }

        @Override
        public int compareTo(Edge e) {
            if (this.zMin == e.zMin) {
                return Float.compare(this.xHit, e.xHit);
            }
            return Integer.compare(this.zMin, e.zMin);
        }
    }
}

