/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justplayerheads_common_neoforge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_neoforge.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CommandJph {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"jph").requires(iCommandSender -> iCommandSender.getEntity() instanceof Player && iCommandSender.permissions().hasPermission(Permissions.COMMANDS_ADMIN))).then(Commands.literal((String)"head").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(command -> {
            int amount = 1;
            int specifiedAmount = IntegerArgumentType.getInteger((CommandContext)command, (String)"amount");
            if (specifiedAmount > 1 && specifiedAmount <= 64) {
                amount = specifiedAmount;
            }
            CommandJph.processJph((CommandContext<CommandSourceStack>)command, amount);
            return 1;
        }))))).then(Commands.literal((String)"head").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(command -> {
            CommandJph.processJph((CommandContext<CommandSourceStack>)command, 1);
            return 1;
        })))).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Allows you to get the head of a player.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" Usage: /jph playerName (amount)", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }));
    }

    public static void processJph(CommandContext<CommandSourceStack> command, Integer amount) {
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        String target = StringArgumentType.getString(command, (String)"name");
        ItemStack headStack = PlayerHeadCacheFeature.getPlayerHeadStackFromCache((ServerLevel)source.getLevel(), (String)target);
        if (headStack != null) {
            headStack.setCount(amount.intValue());
            String message = "Succesfully generated the head of the player '" + target + "'.";
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)message, (ChatFormatting)ChatFormatting.DARK_GREEN);
            ItemFunctions.giveOrDropItemStack((Player)source.getPlayer(), (ItemStack)headStack);
        } else {
            String message = "Unable to generate the player head. Either the player '" + target + "' does not exist or the Mojang API server has had too many requests in a short period of time.";
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)message, (ChatFormatting)ChatFormatting.RED);
        }
    }
}

