/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Actions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Prisoner;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Summon;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.arrow.SpectralArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PkLivingEvents {
    public static float onDamagePumpkillager(Level level, Entity entity, DamageSource damageSource, float damageAmount) {
        boolean yeet;
        if (entity.getTags().contains("pumpkillagersquest.summoned") && damageSource.getMsgId().equals("lightningBolt")) {
            return 0.0f;
        }
        if (!(entity instanceof Villager) && !(entity instanceof Player)) {
            return damageAmount;
        }
        Entity sourceEntity = damageSource.getEntity();
        Entity directSourceEntity = damageSource.getDirectEntity();
        if (entity instanceof Player) {
            BlockPos ppos = entity.blockPosition();
            if (damageSource.toString().contains("explosion") && (Data.allPumpkillagers.get(level).size() > 0 || Data.allPrisoners.get(level).size() > 0)) {
                for (Entity nearbyEntity : level.getEntities(null, new AABB((double)(ppos.getX() - 10), (double)(ppos.getY() - 10), (double)(ppos.getZ() - 10), (double)(ppos.getX() + 10), (double)(ppos.getY() + 10), (double)(ppos.getZ() + 10)))) {
                    if (!(nearbyEntity instanceof Villager) || !Util.isPumpkillager(nearbyEntity) && !Util.isPrisoner(nearbyEntity)) continue;
                    return 0.0f;
                }
            }
            return damageAmount;
        }
        if (!Util.isPumpkillager(entity)) {
            if (Util.isPrisoner(entity)) {
                if (sourceEntity instanceof LivingEntity && !(sourceEntity instanceof Player)) {
                    Manage.yeetLivingEntityIntoSky(level, (LivingEntity)sourceEntity);
                }
                return 0.0f;
            }
            return damageAmount;
        }
        Villager pumpkillager = (Villager)entity;
        BlockPos pos = pumpkillager.blockPosition();
        Set pumpkillagerTags = pumpkillager.getTags();
        float returnDamage = damageAmount;
        if (!pumpkillagerTags.contains("pumpkillagersquest.isweakened")) {
            returnDamage = 0.0f;
        } else if (!(sourceEntity instanceof Player)) {
            returnDamage = 0.0f;
        }
        boolean bl = yeet = !pumpkillagerTags.contains("pumpkillagersquest.nodamage") && !pumpkillagerTags.contains("pumpkillagersquest.isweakened");
        if (sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            if (yeet) {
                MessageFunctions.sendMessage((Player)player, (MutableComponent)Component.literal((String)""));
                Conversations.addMessage(level, pumpkillager, player, "You cannot kill me, " + player.getName().getString() + ".", ChatFormatting.WHITE, 0);
                Conversations.addMessage(level, pumpkillager, player, "I will be back.", ChatFormatting.WHITE, 0);
                pumpkillager.getTags().add("pumpkillagersquest.preventactions");
                Manage.initiateCharacterLeave(level, pumpkillager);
            } else if (!pumpkillagerTags.contains("pumpkillagersquest.isweakened")) {
                if (directSourceEntity instanceof SpectralArrow) {
                    pumpkillager.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE));
                    pumpkillager.getTags().add("pumpkillagersquest.isweakened");
                    pumpkillager.getTags().remove("pumpkillagersquest.nodamage");
                    Actions.startWeakenedBossEvent(level, pumpkillager, player);
                    return returnDamage;
                }
                if (!player.isCreative()) {
                    Conversations.addMessageWithoutPrefix(level, pumpkillager, player, "Your damage is reflected back to you!", ChatFormatting.GRAY, 0);
                    float playerDamage = damageAmount;
                    if (playerDamage > 3.0f) {
                        playerDamage = 3.0f;
                    }
                    player.hurtServer((ServerLevel)level, level.damageSources().mobAttack((LivingEntity)pumpkillager), playerDamage);
                }
                if (pumpkillagerTags.contains("pumpkillagersquest.finalform")) {
                    Conversations.addEmptyMessage(level, pumpkillager, player, 0);
                    Conversations.addMessageWithoutPrefix(level, pumpkillager, player, "It doesn't look like you did any damage!", ChatFormatting.GRAY, 10);
                    Conversations.addMessageWithoutPrefix(level, pumpkillager, player, "Perhaps Jax o'Saturn's spectral arrows could weaken him?", ChatFormatting.GRAY, 20);
                    Prisoner.checkForSpectralArrows(level, pumpkillager, player);
                }
            } else {
                ServerBossEvent serverBossEvent = Data.pumpkillagerBossEvents.get(pumpkillager);
                float currentHealth = pumpkillager.getHealth();
                float newHealth = currentHealth - damageAmount;
                returnDamage = 0.0f;
                EntityFunctions.forceSetHealth((LivingEntity)pumpkillager, (float)newHealth);
                if (serverBossEvent != null) {
                    serverBossEvent.setProgress(newHealth / Data.pumpkillagerMaxHealth);
                }
                if (!pumpkillager.getTags().contains("pumpkillagersquest.saidouch")) {
                    Conversations.addMessage(level, pumpkillager, player, "Ouch!", ChatFormatting.GRAY, 0);
                    pumpkillager.getTags().add("pumpkillagersquest.saidouch");
                }
                Summon.checkForNewSummon(level, pumpkillager, player, newHealth);
            }
        } else if (sourceEntity instanceof LivingEntity && !sourceEntity.getTags().contains("pumpkillagersquest.summoned")) {
            Manage.yeetLivingEntityIntoSky(level, (LivingEntity)sourceEntity);
        }
        return returnDamage;
    }

    public static boolean onLivingDeath(LivingEntity livingEntity, DamageSource damageSource, float damageAmount) {
        if (livingEntity instanceof Player) {
            if (Data.pumpkillagerPlayerTarget.size() > 0) {
                Player player = (Player)livingEntity;
                Level level = player.level();
                for (Villager pumpkillager : Data.pumpkillagerPlayerTarget.keySet()) {
                    Player targetPlayer;
                    if (!pumpkillager.getTags().contains("pumpkillagersquest.finalform") || !(targetPlayer = Data.pumpkillagerPlayerTarget.get(pumpkillager)).getName().getString().equals(player.getName().getString())) continue;
                    targetPlayer.getTags().add("pumpkillagersquest.diedonce");
                    targetPlayer.getTags().remove("pumpkillagersquest.aimforfeet");
                    Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
                    Conversations.addMessage(level, pumpkillager, player, "I knew you couldn't defeat me, " + targetPlayer.getName().getString() + ".", ChatFormatting.WHITE, 1);
                    Conversations.addMessage(level, pumpkillager, player, "Bye.", ChatFormatting.WHITE, 20);
                    Manage.initiateCharacterLeave(level, pumpkillager);
                    return true;
                }
            }
        } else if (Util.isPumpkillager((Entity)livingEntity)) {
            Villager pumpkillager = (Villager)livingEntity;
            pumpkillager.setHealth(1000.0f);
            Actions.shrinkAndKillPumpkillager(pumpkillager.level(), pumpkillager, Data.pumpkillagerPlayerTarget.get(pumpkillager));
            return false;
        }
        return true;
    }

    public static void onEntityItemDrop(Level level, LivingEntity livingEntity, DamageSource damageSource) {
        if (level.isClientSide()) {
            return;
        }
        if (!livingEntity.hasCustomName()) {
            return;
        }
        String entityName = livingEntity.getName().getString();
        if (!entityName.contains("Ghost")) {
            return;
        }
        ItemStack headStack = livingEntity.getItemBySlot(EquipmentSlot.HEAD);
        Item headItem = headStack.getItem();
        if (headItem instanceof PlayerHeadItem) {
            BlockPos epos = livingEntity.blockPosition();
            TaskFunctions.enqueueTask((Level)level, () -> {
                ArrayList<ItemEntity> dropEntities = new ArrayList<ItemEntity>();
                for (Object ea : level.getEntities(null, new AABB((double)(epos.getX() - 1), (double)(epos.getY() - 1), (double)(epos.getZ() - 1), (double)(epos.getX() + 1), (double)(epos.getY() + 1), (double)(epos.getZ() + 1)))) {
                    if (!(ea instanceof ItemEntity)) continue;
                    dropEntities.add((ItemEntity)ea);
                }
                boolean foundStack = false;
                for (ItemEntity dropEntity : dropEntities) {
                    if (!dropEntity.getItem().getItem().equals(headItem)) continue;
                    foundStack = true;
                    break;
                }
                Vec3 vec = livingEntity.position();
                if (!foundStack) {
                    level.addFreshEntity((Entity)new ItemEntity(level, vec.x, vec.y + 0.5, vec.z, headStack));
                    Entity sourceEntity = damageSource.getEntity();
                    if (sourceEntity instanceof Player) {
                        Player player = (Player)sourceEntity;
                        String deathMessageString = "You'll never get away with this!";
                        if (entityName.contains("Rider")) {
                            deathMessageString = "No! This was supposed to be a new age!";
                        }
                        Data.messagesToSend.get(level).add((Pair<Player, MutableComponent>)new Pair((Object)player, (Object)Data.addCharacterPrefix(entityName, player, Component.translatable((String)deathMessageString))));
                    }
                }
            }, (int)0);
        }
    }
}

