/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_forge.events;

import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.ExplosionFunctions;
import com.natamus.pumpkillagersquest_common_forge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_forge.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_forge.util.Data;
import com.natamus.pumpkillagersquest_common_forge.util.QuestData;
import com.natamus.pumpkillagersquest_common_forge.util.Util;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.phys.AABB;

public class PkOtherEvents {
    public static void onTNTExplode(Level level, Entity sourceEntity, Explosion explosion) {
        if (level.isClientSide()) {
            return;
        }
        if (!(sourceEntity instanceof PrimedTnt)) {
            return;
        }
        BlockPos pos = sourceEntity.blockPosition();
        if (Data.allPrisoners.get(level).size() > 0) {
            for (Villager prisoner : Data.allPrisoners.get(level)) {
                BlockPos prisonerPos = prisoner.blockPosition();
                if (!BlockPosFunctions.withinDistance((BlockPos)pos, (BlockPos)prisonerPos, (int)10).booleanValue()) continue;
                ExplosionFunctions.clearExplosion((Explosion)explosion);
            }
        }
        if (!(level.getBlockState(pos.north()).getBlock() instanceof RedStoneWireBlock)) {
            return;
        }
        ArrayList<Integer> redstonePositionsLeft = new ArrayList<Integer>(QuestData.questOneRitualBlockPositions);
        int i = 0;
        for (BlockPos bpa : BlockPos.betweenClosed((int)(pos.getX() - 3), (int)pos.getY(), (int)(pos.getZ() - 3), (int)(pos.getX() + 3), (int)pos.getY(), (int)(pos.getZ() + 3))) {
            if (level.getBlockState(bpa).getBlock() instanceof RedStoneWireBlock) {
                redstonePositionsLeft.remove((Object)i);
            }
            ++i;
        }
        if (redstonePositionsLeft.size() == 0) {
            ExplosionFunctions.clearExplosion((Explosion)explosion);
            Player player = null;
            for (Entity ea : level.getEntities(null, new AABB((double)(pos.getX() - 20), (double)(pos.getY() - 20), (double)(pos.getZ() - 20), (double)(pos.getX() + 20), (double)(pos.getY() + 20), (double)(pos.getZ() + 20)))) {
                if (!(ea instanceof Player)) continue;
                player = (Player)ea;
                break;
            }
            if (player == null) {
                return;
            }
            if (player.getTags().contains("pumpkillagersquest.unleashed")) {
                if (!player.getTags().contains("pumpkillagersquest.completedquest")) {
                    Conversations.addEmptyMessage(level, null, player, 0);
                    Conversations.addMessageWithoutPrefix(level, null, player, "You feel a blast of magic, but nothing happens. The ritual must have been completed already. Maybe a prisoner in the prisoner camp could help find the Pumpkillager.", ChatFormatting.GRAY, 10);
                }
                return;
            }
            if (!player.getTags().contains("pumpkillagersquest.questbookgiven")) {
                Conversations.addMessageWithoutPrefix(level, null, player, "You feel a blast of magic, but nothing happens. You'll probably need to talk to the Pumpkillager first.", ChatFormatting.GRAY, 10);
                return;
            }
            Manage.spawnPumpkillager(level, player, pos, 1, 1);
        }
    }

    public static boolean onPistonMove(Level level, BlockPos blockPos, Direction direction, boolean isExtending) {
        if (level.isClientSide()) {
            return true;
        }
        BlockPos pos = blockPos.relative(direction);
        for (Entity ea : level.getEntities(null, new AABB((double)(pos.getX() - 3), (double)(pos.getY() - 3), (double)(pos.getZ() - 3), (double)(pos.getX() + 3), (double)(pos.getY() + 3), (double)(pos.getZ() + 3)))) {
            if (!Util.isPumpkillager(ea)) continue;
            return false;
        }
        return true;
    }
}

