/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.pumpkillagersquest_common_forge.util.Data;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CommandPumpkillager {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pumpkillager").requires(iCommandSender -> iCommandSender.permissions().hasPermission(Permissions.COMMANDS_ADMIN))).then(Commands.literal((String)"reset").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            for (Entity entity : EntityArgument.getEntities((CommandContext)command, (String)"targets")) {
                List tags = entity.getTags().stream().toList();
                int deletedCount = 0;
                for (String tag : tags) {
                    if (!tag.contains("pumpkillagersquest")) continue;
                    entity.getTags().remove(tag);
                    ++deletedCount;
                }
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully deleted " + deletedCount + " pumpkillager tags for " + entity.getName().getString() + "."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            }
            return 1;
        })))).then(Commands.literal((String)"book").then(Commands.literal((String)"pumpkillagers-quest").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                ServerPlayer player = source.getPlayerOrException();
                ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)Data.getQuestbook(player.level()));
                MessageFunctions.sendMessage((Player)player, (String)"You have been given the 'Pumpkillager's Quest' book.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            }
            catch (CommandSyntaxException ex) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            return 1;
        })))).then(Commands.literal((String)"book").then(Commands.literal((String)"stopping-the-pumpkillager").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                ServerPlayer player = source.getPlayerOrException();
                ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)Data.getStopPkbook(player.level()));
                MessageFunctions.sendMessage((Player)player, (String)"You have been given the 'Stopping the Pumpkillager' book.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            }
            catch (CommandSyntaxException ex) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            return 1;
        }))));
    }
}

