/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_fabric.pumpkillager;

import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Actions;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_fabric.util.Data;
import com.natamus.pumpkillagersquest_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1604;
import net.minecraft.class_1613;
import net.minecraft.class_1632;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class Summon {
    public static void summonFinalBossMinions(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer, int summonId) {
        if (level.method_8608()) {
            return;
        }
        if (pumpkillager.method_5752().contains("pumpkillagersquest.preventactions")) {
            return;
        }
        switch (summonId) {
            case 0: {
                Summon.summonFirstWave(level, pumpkillager, targetPlayer);
                break;
            }
            case 1: {
                Summon.summonSecondWave(level, pumpkillager, targetPlayer);
                break;
            }
            case 2: {
                Summon.summonThirdWave(level, pumpkillager, targetPlayer);
                break;
            }
            case 3: {
                Summon.summonFourthWave(level, pumpkillager, targetPlayer);
            }
        }
    }

    public static void checkForNewSummon(class_1937 level, class_1646 pumpkillager, class_1657 player, float newHealth) {
        float maxHealth = Data.pumpkillagerMaxHealth;
        float healthPercentage = newHealth / maxHealth;
        Set tags = pumpkillager.method_5752();
        if ((double)healthPercentage <= 0.75 && !tags.contains("pumpkillagersquest.secondwave")) {
            Summon.summonFinalBossMinions(level, pumpkillager, player, 1);
            pumpkillager.method_5752().add("pumpkillagersquest.secondwave");
            return;
        }
        if ((double)healthPercentage <= 0.5 && !tags.contains("pumpkillagersquest.thirdwave")) {
            Summon.summonFinalBossMinions(level, pumpkillager, player, 2);
            pumpkillager.method_5752().add("pumpkillagersquest.thirdwave");
            return;
        }
        if ((double)healthPercentage <= 0.25 && !tags.contains("pumpkillagersquest.fourthwave")) {
            Summon.summonFinalBossMinions(level, pumpkillager, player, 3);
            pumpkillager.method_5752().add("pumpkillagersquest.fourthwave");
        }
    }

    public static void summonMinionsAround(class_1937 level, class_1646 pumpkillager, class_1657 player, class_2338 centerPos, List<class_1309> minionsToSpawn) {
        if (pumpkillager.method_5752().contains("pumpkillagersquest.iskilled")) {
            return;
        }
        ArrayList<class_2338> positions = new ArrayList<class_2338>(Arrays.asList(centerPos.method_10076(4).method_10062(), centerPos.method_10089(4).method_10062(), centerPos.method_10077(4).method_10062(), centerPos.method_10088(4).method_10062()));
        class_3218 serverLevel = (class_3218)level;
        MinecraftServer minecraftServer = serverLevel.method_8503();
        int i = 0;
        for (class_1309 livingEntity : minionsToSpawn) {
            livingEntity.method_5752().add("pumpkillagersquest.summoned");
            livingEntity.method_5752().add("pumpkillagersquest.justadded");
            class_2338 rawSpawnPos = (class_2338)positions.get(i);
            class_2338 spawnPos = BlockPosFunctions.getSurfaceBlockPos((class_3218)serverLevel, (int)rawSpawnPos.method_10263(), (int)rawSpawnPos.method_10260());
            livingEntity.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (livingEntity instanceof class_1308) {
                ((class_1308)livingEntity).method_5952(false);
            }
            level.method_8649((class_1297)livingEntity);
            Util.spawnLightning(level, spawnPos, livingEntity, player, true);
            ++i;
        }
    }

    public static void summonFirstWave(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        class_2338 pos = pumpkillager.method_24515().method_10062();
        class_1799 swordStack = new class_1799((class_1935)class_1802.field_8371, 1);
        swordStack.method_7978((class_6880)level.method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9109), 1);
        ArrayList<class_1309> minionsToSummon = new ArrayList<class_1309>();
        for (int i = 0; i < 4; ++i) {
            class_1641 zombieVillager = (class_1641)class_1299.field_6054.method_5883(level, class_3730.field_16467);
            zombieVillager.method_6122(class_1268.field_5808, swordStack.method_7972());
            EntityFunctions.getTargetSelector((class_1308)zombieVillager).method_35113(goal -> true);
            EntityFunctions.getTargetSelector((class_1308)zombieVillager).method_6277(2, (class_1352)new class_1400((class_1308)zombieVillager, class_1657.class, false));
            minionsToSummon.add((class_1309)zombieVillager);
        }
        Summon.summonMinionsAround(level, pumpkillager, player, pos, minionsToSummon);
        Conversations.addEmptyMessage(level, pumpkillager, player, 0);
        Conversations.addMessage(level, pumpkillager, player, "My zombified followers, forwards!", class_124.field_1061, 0);
        pumpkillager.method_5752().add("pumpkillagersquest.summoninglightning");
        Actions.pumpkillagerLightning(level, pumpkillager, player);
    }

    public static void summonSecondWave(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        class_2338 pos = pumpkillager.method_24515().method_10062();
        class_1799 bowStack = new class_1799((class_1935)class_1802.field_8102, 1);
        bowStack.method_7978((class_6880)level.method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9109), 1);
        ArrayList<class_1309> minionsToSummon = new ArrayList<class_1309>();
        for (int i = 0; i < 4; ++i) {
            class_1613 skeleton = (class_1613)class_1299.field_6137.method_5883(level, class_3730.field_16467);
            skeleton.method_6122(class_1268.field_5808, bowStack.method_7972());
            EntityFunctions.getTargetSelector((class_1308)skeleton).method_35113(goal -> true);
            EntityFunctions.getTargetSelector((class_1308)skeleton).method_6277(2, (class_1352)new class_1400((class_1308)skeleton, class_1657.class, false));
            minionsToSummon.add((class_1309)skeleton);
        }
        Summon.summonMinionsAround(level, pumpkillager, player, pos, minionsToSummon);
        Conversations.addEmptyMessage(level, pumpkillager, player, 0);
        Conversations.addMessage(level, pumpkillager, player, "Attack, my skeletons!", class_124.field_1061, 0);
    }

    public static void summonThirdWave(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        class_2338 pos = pumpkillager.method_24515().method_10062();
        ArrayList<class_1309> minionsToSummon = new ArrayList<class_1309>();
        for (int i = 0; i < 2; ++i) {
            minionsToSummon.add((class_1309)class_1299.field_6145.method_5883(level, class_3730.field_16467));
            minionsToSummon.add((class_1309)class_1299.field_6078.method_5883(level, class_3730.field_16467));
        }
        Summon.summonMinionsAround(level, pumpkillager, player, pos, minionsToSummon);
        Conversations.addEmptyMessage(level, pumpkillager, player, 0);
        Conversations.addMessage(level, pumpkillager, player, "My loyal witches and your pets, destroy the human!", class_124.field_1061, 0);
    }

    public static void summonFourthWave(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        class_2378 enchantmentRegistry = level.method_30349().method_30530(class_7924.field_41265);
        class_2338 pos = pumpkillager.method_24515().method_10062();
        class_1799 axeStack = new class_1799((class_1935)class_1802.field_8406, 1);
        axeStack.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9109), 1);
        class_1799 crossbowStack = new class_1799((class_1935)class_1802.field_8399, 1);
        crossbowStack.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9109), 1);
        ArrayList<class_1309> minionsToSummon = new ArrayList<class_1309>();
        for (int i = 0; i < 2; ++i) {
            class_1632 vindicator = (class_1632)class_1299.field_6117.method_5883(level, class_3730.field_16467);
            class_1604 pillager = (class_1604)class_1299.field_6105.method_5883(level, class_3730.field_16467);
            vindicator.method_6122(class_1268.field_5808, axeStack.method_7972());
            pillager.method_6122(class_1268.field_5808, crossbowStack.method_7972());
            EntityFunctions.getTargetSelector((class_1308)vindicator).method_35113(goal -> true);
            EntityFunctions.getTargetSelector((class_1308)pillager).method_35113(goal -> true);
            EntityFunctions.getTargetSelector((class_1308)vindicator).method_6277(2, (class_1352)new class_1400((class_1308)vindicator, class_1657.class, false));
            EntityFunctions.getTargetSelector((class_1308)pillager).method_6277(2, (class_1352)new class_1400((class_1308)pillager, class_1657.class, true));
            minionsToSummon.add((class_1309)vindicator);
            minionsToSummon.add((class_1309)pillager);
        }
        Summon.summonMinionsAround(level, pumpkillager, player, pos, minionsToSummon);
        Conversations.addEmptyMessage(level, pumpkillager, player, 0);
        Conversations.addMessage(level, pumpkillager, player, "Illagers! Finish that scum!", class_124.field_1061, 0);
    }
}

