/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.treeharvester_common_forge.config.ConfigHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.material.MapColor;

public class Util {
    public static boolean isTreeLog(Block block) {
        try {
            return (CompareBlockFunctions.isTreeLog((Block)block) || Util.isGiantMushroomStemBlock(block) || Util.isTreeRoot(block)) && !block.getName().getString().toLowerCase().contains("stripped");
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    public static boolean isTreeLeaf(Block block) {
        return CompareBlockFunctions.isTreeLeaf((Block)block, (boolean)ConfigHandler.enableNetherTrees) || Util.isGiantMushroomLeafBlock(block);
    }

    public static boolean isSapling(Block block) {
        return CompareBlockFunctions.isSapling((Block)block) || block instanceof MushroomBlock && ConfigHandler.enableHugeMushrooms;
    }

    public static boolean isNetherTreeLeaf(Block block) {
        return block.equals(Blocks.NETHER_WART_BLOCK) || block.equals(Blocks.WARPED_WART_BLOCK) || block.equals(Blocks.SHROOMLIGHT);
    }

    public static boolean isTreeRoot(Block block) {
        return block instanceof MangroveRootsBlock;
    }

    public static boolean isGiantMushroomStemBlock(Block block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        MapColor materialcolour = block.defaultMapColor();
        return block instanceof HugeMushroomBlock && materialcolour.equals(MapColor.WOOL);
    }

    public static boolean isGiantMushroomLeafBlock(Block block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        MapColor materialcolour = block.defaultMapColor();
        return block instanceof HugeMushroomBlock && (materialcolour.equals(MapColor.COLOR_RED) || materialcolour.equals(MapColor.DIRT));
    }

    public static boolean isMangroveRootOrLog(Block block) {
        return block instanceof MangroveRootsBlock || block.equals(Blocks.MANGROVE_LOG);
    }

    public static boolean isAzaleaLeaf(Block block) {
        return block.equals(Blocks.AZALEA_LEAVES) || block.equals(Blocks.FLOWERING_AZALEA_LEAVES);
    }

    public static boolean areEqualLogTypes(Block one, Block two) {
        if (!Util.isTreeLog(one) || !Util.isTreeLog(two)) {
            return false;
        }
        if (Util.isMangroveRootOrLog(one) && Util.isMangroveRootOrLog(two)) {
            return true;
        }
        String oneIdentifier = one.getName().getString().split(" ")[0];
        String twoIdentifier = two.getName().getString().split(" ")[0];
        return oneIdentifier.equals(twoIdentifier);
    }

    public static Pair<Boolean, List<BlockPos>> isConnectedToLogs(Level level, BlockPos startpos) {
        List recursiveList = BlockPosFunctions.getBlocksNextToEachOtherMaterial((Level)level, (BlockPos)startpos, Arrays.asList(MapColor.WOOD), (int)6);
        for (BlockPos connectedpos : recursiveList) {
            Block connectedblock = level.getBlockState(connectedpos).getBlock();
            if (!Util.isTreeLog(connectedblock)) continue;
            return new Pair((Object)true, (Object)recursiveList);
        }
        return new Pair((Object)false, (Object)recursiveList);
    }
}

