/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.alternativeworldsavelocation_common_forge.mixin;

import com.mojang.datafixers.DataFixer;
import com.natamus.alternativeworldsavelocation_common_forge.util.Util;
import com.natamus.collective_common_forge.functions.ConfigFunctions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.main.GameConfig;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class}, priority=1001)
public class MinecraftMixin {
    @Shadow
    @Final
    private DataFixer fixerUpper;
    @Shadow
    @Mutable
    @Final
    private LevelStorageSource levelSource;

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="TAIL")})
    private void Minecraft(GameConfig i, CallbackInfo ci) {
        boolean changeDefaultWorldSaveLocation = false;
        boolean changeDefaultWorldBackupLocation = false;
        String rawsavespath = "";
        String rawbackupspath = "";
        List rawconfig = ConfigFunctions.getRawConfigValues((String)"alternativeworldsavelocation");
        for (String rc : rawconfig) {
            if (rc.contains("changeDefaultWorldSaveLocation")) {
                changeDefaultWorldSaveLocation = rc.contains("true");
                continue;
            }
            if (rc.contains("changeDefaultWorldBackupLocation")) {
                changeDefaultWorldBackupLocation = rc.contains("true");
                continue;
            }
            if (rc.contains("defaultMinecraftWorldSaveLocation") && rc.contains("\":")) {
                rawsavespath = rc.split("\":")[1].replace("\"", "").trim();
                continue;
            }
            if (!rc.contains("defaultMinecraftWorldBackupLocation") || !rc.contains("\\\":")) continue;
            rawbackupspath = rc.split("\":")[1].replace("\"", "").trim();
        }
        if (!changeDefaultWorldSaveLocation) {
            return;
        }
        String savespath = Util.returnSystemSpecificPath(rawsavespath);
        Object backuppath = savespath + File.separator + "_Backups";
        if (changeDefaultWorldBackupLocation) {
            backuppath = Util.returnSystemSpecificPath(rawbackupspath);
        }
        this.levelSource = new LevelStorageSource(Paths.get(savespath, new String[0]), Paths.get((String)backuppath, new String[0]), LevelStorageSource.parseValidator((Path)Minecraft.getInstance().gameDirectory.toPath().resolve("allowed_symlinks.txt")), this.fixerUpper);
    }
}

