/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.betterspawnercontrol.neoforge.events;

import com.mojang.datafixers.util.Either;
import com.natamus.betterspawnercontrol_common_neoforge.events.MobSpawnerEvent;
import com.natamus.collective_common_neoforge.functions.WorldFunctions;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class NeoForgeMobSpawnerEvent {
    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.PositionCheck e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        BaseSpawner msbl = e.getSpawner();
        if (msbl != null) {
            BlockPos spawnerPos;
            Either spawnerEntityEither = msbl.getOwner();
            if (spawnerEntityEither == null) {
                return;
            }
            if (spawnerEntityEither.left().isPresent()) {
                spawnerPos = ((BlockEntity)spawnerEntityEither.left().get()).getBlockPos();
            } else if (spawnerEntityEither.right().isPresent()) {
                spawnerPos = ((Entity)spawnerEntityEither.right().get()).blockPosition();
            } else {
                return;
            }
            if (!MobSpawnerEvent.onMobSpawn(e.getEntity(), (ServerLevel)level, spawnerPos, null)) {
                e.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
            }
        }
    }
}

