/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.firespreadtweaks.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.firespreadtweaks_common_forge.events.FireSpreadEvent;
import java.lang.invoke.MethodHandles;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeFireSpreadEvent {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeFireSpreadEvent.class);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent.Post e) {
        Level level = e.level();
        if (level.isClientSide()) {
            return;
        }
        FireSpreadEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        FireSpreadEvent.onWorldLoad((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        FireSpreadEvent.onWorldUnload((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onNeighbourNotice(BlockEvent.NeighborNotifyEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        FireSpreadEvent.onNeighbourNotice(level, e.getPos(), e.getState(), e.getNotifiedSides(), e.getForceRedstoneUpdate());
    }
}

