/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_neoforge.events;

import com.mojang.blaze3d.platform.Window;
import com.natamus.areas_common_neoforge.config.ConfigHandler;
import com.natamus.areas_common_neoforge.data.ClientConstants;
import com.natamus.areas_common_neoforge.data.GUIVariables;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.ARGB;
import org.joml.Matrix3x2fStack;

public class GUIEvent {
    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!GUIVariables.hudMessage.equals("")) {
            String[] rgbs;
            Font font = ClientConstants.mc.font;
            Window scaled = ClientConstants.mc.getWindow();
            int width = scaled.getGuiScaledWidth();
            double stringWidth = font.width(GUIVariables.hudMessage);
            if (GUIVariables.guiOpacity <= 0) {
                GUIVariables.guiOpacity = 0;
                GUIVariables.hudMessage = "";
                return;
            }
            if (GUIVariables.guiOpacity > 255) {
                GUIVariables.guiOpacity = 255;
            }
            int colour = ARGB.color((int)GUIVariables.guiOpacity, (int)ConfigHandler.HUD_RGB_R, (int)ConfigHandler.HUD_RGB_G, (int)ConfigHandler.HUD_RGB_B);
            if (!GUIVariables.rgb.equals("") && (rgbs = GUIVariables.rgb.split(",")).length == 3) {
                try {
                    int r = Integer.parseInt(rgbs[0]);
                    if (r < 0) {
                        r = 0;
                    } else if (r > 255) {
                        r = 255;
                    }
                    int g = Integer.parseInt(rgbs[1]);
                    if (g < 0) {
                        g = 0;
                    } else if (g > 255) {
                        g = 255;
                    }
                    int b = Integer.parseInt(rgbs[2]);
                    if (b < 0) {
                        b = 0;
                    } else if (b > 255) {
                        b = 255;
                    }
                    colour = ARGB.color((int)GUIVariables.guiOpacity, (int)r, (int)g, (int)b);
                }
                catch (IllegalArgumentException ex) {
                    GUIVariables.rgb = "";
                    GUIVariables.hudMessage = "";
                }
            }
            Matrix3x2fStack matrixStack = guiGraphics.pose();
            matrixStack.pushMatrix();
            float modifier = (float)ConfigHandler.HUD_FontSizeScaleModifier + 0.5f;
            matrixStack.scale(modifier, modifier);
            guiGraphics.drawString(font, GUIVariables.hudMessage, (int)((double)Math.round((float)width / 2.0f / modifier) - stringWidth / 2.0), ConfigHandler.HUDMessageHeightOffset, colour, ConfigHandler.showHUDTextShadow);
            matrixStack.popMatrix();
            if (!GUIVariables.currentMessage.equals(GUIVariables.hudMessage)) {
                GUIVariables.currentMessage = GUIVariables.hudMessage;
                GUIVariables.ticksLeftBeforeFade = ConfigHandler.HUDMessageFadeDelayMs / 50;
            }
        }
    }

    public static void tickHUDFade() {
        if (GUIVariables.ticksLeftBeforeFade == 0) {
            GUIVariables.ticksLeftBeforeFade = -1;
        } else if (GUIVariables.ticksLeftBeforeFade > 0) {
            --GUIVariables.ticksLeftBeforeFade;
        } else if (!GUIVariables.hudMessage.equals("")) {
            if (GUIVariables.guiOpacity < 0) {
                GUIVariables.hudMessage = "";
                GUIVariables.rgb = "";
                return;
            }
            GUIVariables.guiOpacity -= 5;
        }
    }
}

