/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_neoforge.events;

import com.natamus.areas_common_neoforge.data.AreaVariables;
import com.natamus.areas_common_neoforge.functions.ZoneFunctions;
import com.natamus.areas_common_neoforge.objects.AreaObject;
import com.natamus.areas_common_neoforge.util.Util;
import com.natamus.collective_common_neoforge.functions.HashMapFunctions;
import com.natamus.collective_common_neoforge.functions.SignFunctions;
import com.natamus.collective_common_neoforge.functions.StringFunctions;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AreaEvent {
    public static HashMap<Level, Integer> tickDelayPerLevel = new HashMap();

    public static void onWorldTick(ServerLevel level) {
        int ticks = (Integer)HashMapFunctions.computeIfAbsent(tickDelayPerLevel, (Object)level, k -> 1);
        if (ticks % 20 != 0) {
            tickDelayPerLevel.put((Level)level, ticks + 1);
            return;
        }
        tickDelayPerLevel.put((Level)level, 1);
        for (BlockPos signPos : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(AreaVariables.newSignsToCheck, (Object)level, k -> new CopyOnWriteArrayList())) {
            BlockEntity blockEntity = level.getBlockEntity(signPos);
            if (!(blockEntity instanceof SignBlockEntity)) {
                AreaVariables.newSignsToCheck.get(level).remove(signPos);
                continue;
            }
            int checksLeft = ((HashMap)HashMapFunctions.computeIfAbsent(AreaVariables.newSignChecksLeft, (Object)level, k -> new HashMap())).getOrDefault(signPos, 60);
            SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
            List signLines = SignFunctions.getSignText((BlockEntity)blockEntity);
            if (!String.join((CharSequence)"", signLines).equals("")) {
                AreaObject areaObject = Util.getAreaSign((Level)level, signPos);
                if (areaObject == null) {
                    AreaVariables.newSignsToCheck.get(level).remove(signPos);
                    AreaVariables.newSignChecksLeft.get(level).remove(signPos);
                    continue;
                }
                String zonePrefix = "Area";
                String rgb = "";
                boolean customrgb = false;
                int i = -1;
                for (String line : signLines) {
                    String possiblergb;
                    if (++i == 0 && !ZoneFunctions.hasZonePrefix(line)) continue;
                    if (i > 3) break;
                    if (line.length() < 1) continue;
                    for (String zpx : ZoneFunctions.zonePrefixes) {
                        if (!line.toLowerCase().contains(zpx)) continue;
                        zonePrefix = StringFunctions.capitalizeFirst((String)zpx.replace("[", "").replace("]", ""));
                        break;
                    }
                    if ((possiblergb = ZoneFunctions.getZoneRGB(line.toLowerCase())).equals("")) continue;
                    customrgb = true;
                }
                Util.updateAreaSign((Level)level, signPos, signBlockEntity, signLines, areaObject.areaName, zonePrefix, areaObject.customRGB, areaObject.radius, customrgb);
                AreaVariables.newSignsToCheck.get(level).remove(signPos);
                AreaVariables.newSignChecksLeft.get(level).remove(signPos);
                continue;
            }
            if (checksLeft == 0) {
                AreaVariables.newSignsToCheck.get(level).remove(signPos);
                AreaVariables.newSignChecksLeft.get(level).remove(signPos);
                continue;
            }
            AreaVariables.newSignChecksLeft.get(level).put(signPos, checksLeft - 1);
        }
    }

    public static void onNeighbourNotice(Level level, BlockPos pos, BlockState state, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
        if (level.isClientSide()) {
            return;
        }
        if (Util.isSignBlock(state.getBlock()).booleanValue()) {
            AreaVariables.newSignsToCheck.computeIfAbsent(level, k -> new CopyOnWriteArrayList()).add(pos.immutable());
        }
    }
}

