/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.compacthelpcommand_common_fabric.cmds;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.NumberFunctions;
import com.natamus.compacthelpcommand_common_fabric.config.ConfigHandler;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CommandHelp {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.help.failed"));
    private static final class_124 commandcolour = class_124.method_534((int)ConfigHandler.commandColour);
    private static final class_124 subcommandcolour = class_124.method_534((int)ConfigHandler.subcommandColour);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(command -> CommandHelp.processHelpCommands(dispatcher, (CommandContext<class_2168>)command, 1, (class_2168)command.getSource()))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(command -> CommandHelp.processHelpCommands(dispatcher, (CommandContext<class_2168>)command, IntegerArgumentType.getInteger((CommandContext)command, (String)"page"), (class_2168)command.getSource())))).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(command -> {
            String fakecommand = StringArgumentType.getString((CommandContext)command, (String)"command");
            if (NumberFunctions.isNumeric((String)fakecommand)) {
                return CommandHelp.processHelpCommands(dispatcher, (CommandContext<class_2168>)command, Integer.parseInt(fakecommand), (class_2168)command.getSource());
            }
            ParseResults parseResults = dispatcher.parse(StringArgumentType.getString((CommandContext)command, (String)"command"), (Object)((class_2168)command.getSource()));
            if (parseResults.getContext().getNodes().isEmpty()) {
                throw ERROR_FAILED.create();
            }
            Map commandNodeMap = dispatcher.getSmartUsage(((ParsedCommandNode)Iterables.getLast((Iterable)parseResults.getContext().getNodes())).getNode(), (Object)((class_2168)command.getSource()));
            MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (String)" ", (class_124)class_124.field_1068);
            for (String nextStringVar : commandNodeMap.values()) {
                ((class_2168)command.getSource()).method_9226(() -> {
                    String stringCommand = parseResults.getReader().getString();
                    String csuffix = nextStringVar;
                    if (ConfigHandler.addVerticalBarSpacing) {
                        csuffix = csuffix.replace("|", " | ");
                    }
                    class_5250 tc = class_2561.method_43470((String)"");
                    class_5250 tc0 = class_2561.method_43470((String)("/" + stringCommand + " "));
                    tc0.method_27692(commandcolour);
                    tc.method_10852((class_2561)tc0);
                    class_5250 tc1 = class_2561.method_43470((String)csuffix);
                    tc1.method_27692(subcommandcolour);
                    tc.method_10852((class_2561)tc1);
                    return tc;
                }, false);
            }
            return commandNodeMap.size();
        })));
    }

    private static Integer processHelpCommands(CommandDispatcher<class_2168> dispatcher, CommandContext<class_2168> command, Integer page, class_2168 commandSourceStack) {
        ArrayList<CallSite> scmds = new ArrayList<CallSite>();
        Map map = dispatcher.getSmartUsage((CommandNode)dispatcher.getRoot(), (Object)((class_2168)command.getSource()));
        for (String s : map.values()) {
            String scmd = "/" + s;
            scmds.add((CallSite)((Object)scmd));
        }
        Collections.sort(scmds);
        int amountperpage = ConfigHandler.amountCommandsPerPage;
        int totalcount = scmds.size();
        int totalpages = (int)Math.ceil((float)totalcount / (float)amountperpage) + 1;
        if (page <= 0) {
            page = 1;
        }
        if (page > totalpages) {
            page = totalpages;
        }
        MessageFunctions.sendMessage((class_2168)commandSourceStack, (String)" ", (class_124)class_124.field_1068);
        for (int n = 0; n < amountperpage * page; ++n) {
            if (n < amountperpage * page - amountperpage) continue;
            if (scmds.size() < n + 1) break;
            String commandline = (String)scmds.get(n);
            commandSourceStack.method_9226(() -> {
                String[] cmdlspl = commandline.split(" ");
                String acmd = cmdlspl[0];
                String csuffix = commandline.replaceAll(acmd, "");
                if (ConfigHandler.addVerticalBarSpacing) {
                    csuffix = csuffix.replace("|", " | ");
                }
                class_5250 tc = class_2561.method_43470((String)"");
                class_5250 tc0 = class_2561.method_43470((String)acmd);
                tc0.method_27692(commandcolour);
                tc.method_10852((class_2561)tc0);
                class_5250 tc1 = class_2561.method_43470((String)csuffix);
                tc1.method_27692(subcommandcolour);
                tc.method_10852((class_2561)tc1);
                return tc;
            }, false);
        }
        MessageFunctions.sendMessage((class_2168)commandSourceStack, (String)(" Page " + page + " / " + totalpages + ", /help <page>"), (class_124)class_124.field_1054);
        return 1;
    }
}

