/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.smallernetherportals_common_neoforge.util;

import com.natamus.collective_common_neoforge.services.Services;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;

public class Util {
    /*
     * WARNING - void declaration
     */
    public static void processSmallerPortal(Level world, BlockPos pos) {
        int heighti;
        BlockPos bottomleft;
        String airdirection = "none";
        Rotation rotation = null;
        if (Util.isObsidian(world.getBlockState(pos.east())).booleanValue()) {
            if (Util.isAir(world.getBlockState(pos.west())).booleanValue()) {
                bottomleft = pos.west();
                airdirection = "east";
            } else {
                bottomleft = pos;
                rotation = Rotation.CLOCKWISE_180;
            }
        } else if (Util.isObsidian(world.getBlockState(pos.west())).booleanValue()) {
            if (Util.isAir(world.getBlockState(pos.east())).booleanValue()) {
                airdirection = "east";
            } else {
                rotation = Rotation.CLOCKWISE_180;
            }
            bottomleft = pos;
        } else if (Util.isObsidian(world.getBlockState(pos.north())).booleanValue()) {
            if (Util.isAir(world.getBlockState(pos.south())).booleanValue()) {
                airdirection = "south";
            } else {
                rotation = Rotation.CLOCKWISE_90;
            }
            bottomleft = pos;
        } else if (Util.isObsidian(world.getBlockState(pos.south())).booleanValue()) {
            if (Util.isAir(world.getBlockState(pos.north())).booleanValue()) {
                bottomleft = pos.north();
                airdirection = "south";
            } else {
                bottomleft = pos;
                rotation = Rotation.CLOCKWISE_90;
            }
        } else {
            return;
        }
        bottomleft = bottomleft.immutable();
        if (!Util.isObsidian(world.getBlockState(bottomleft.below())).booleanValue()) {
            return;
        }
        if (Util.isObsidian(world.getBlockState(bottomleft.above(2))).booleanValue()) {
            height = 2;
        } else if (Util.isObsidian(world.getBlockState(bottomleft.above(3))).booleanValue()) {
            height = 3;
        } else {
            return;
        }
        ArrayList<BlockPos> toportals = new ArrayList<BlockPos>();
        for (heighti = height; heighti > 0; --heighti) {
            Block wblock;
            toportals.add(bottomleft.above(heighti - 1).immutable());
            if (airdirection.equals("none")) continue;
            if (airdirection.equals("south")) {
                if (!Util.isObsidian(world.getBlockState(bottomleft.north())).booleanValue()) break;
                wblock = world.getBlockState(bottomleft.south()).getBlock();
                if (Util.isAir(wblock).booleanValue()) {
                    if (!Util.isObsidian(world.getBlockState(bottomleft.south(2))).booleanValue()) break;
                    toportals.add(bottomleft.above(heighti - 1).south().immutable());
                    continue;
                }
                if (Util.isObsidian(wblock).booleanValue()) continue;
                break;
            }
            if (!airdirection.equals("east")) continue;
            if (!Util.isObsidian(world.getBlockState(bottomleft.west()).getBlock()).booleanValue()) break;
            wblock = world.getBlockState(bottomleft.east()).getBlock();
            if (Util.isAir(wblock).booleanValue()) {
                if (!Util.isObsidian(world.getBlockState(bottomleft.east(2))).booleanValue()) break;
                toportals.add(bottomleft.above(heighti - 1).east().immutable());
                continue;
            }
            if (!Util.isObsidian(wblock).booleanValue()) break;
        }
        if (heighti == 0) {
            void var10_15;
            if (rotation == null) {
                rotation = airdirection.equals("east") ? Rotation.CLOCKWISE_180 : Rotation.CLOCKWISE_90;
            }
            int obsidiancount = 0;
            for (BlockPos blockPos : toportals) {
                for (BlockPos tp0around : Util.getBlocksAround(blockPos.immutable(), rotation)) {
                    Block tp0block = world.getBlockState(tp0around).getBlock();
                    if (!Util.isObsidian(tp0block).booleanValue()) continue;
                    ++obsidiancount;
                }
            }
            if (toportals.size() == 2 ? obsidiancount < 6 : obsidiancount < 8) {
                return;
            }
            BlockPos portalpos = null;
            for (BlockPos tp : toportals) {
                world.setBlock(tp, Blocks.NETHER_PORTAL.defaultBlockState().rotate(rotation), 2);
                portalpos = tp;
            }
            if (portalpos == null) {
                return;
            }
            if (airdirection.equals("east")) {
                Direction.Axis axis = Direction.Axis.X;
            } else {
                Direction.Axis axis = Direction.Axis.Z;
            }
            PortalShape size = PortalShape.findAnyShape((BlockGetter)world, portalpos, (Direction.Axis)var10_15);
            Services.EVENTTRIGGER.triggerNetherPortalSpawnEvent(world, portalpos, size);
        }
    }

    public static List<BlockPos> getBlocksAround(BlockPos pos, Rotation rot) {
        ArrayList<BlockPos> around = new ArrayList<BlockPos>();
        BlockPos impos = pos.immutable();
        around.add(impos.above().immutable());
        around.add(impos.below().immutable());
        if (rot.equals((Object)Rotation.CLOCKWISE_90)) {
            around.add(impos.north().immutable());
            around.add(impos.south().immutable());
        } else {
            around.add(impos.east().immutable());
            around.add(impos.west().immutable());
        }
        return around;
    }

    public static List<BlockPos> getFrontBlocks(Level world, BlockPos portalblock) {
        ArrayList<BlockPos> returnblocks = new ArrayList<BlockPos>();
        boolean smallest = false;
        if (Util.isObsidian(world.getBlockState(portalblock.east())).booleanValue() && Util.isObsidian(world.getBlockState(portalblock.west())).booleanValue()) {
            smallest = true;
        } else if (Util.isObsidian(world.getBlockState(portalblock.north())).booleanValue() && Util.isObsidian(world.getBlockState(portalblock.south())).booleanValue()) {
            smallest = true;
        } else if (Util.isPortal(world.getBlockState(portalblock.north())).booleanValue()) {
            portalblock = portalblock.north().immutable();
        } else if (Util.isPortal(world.getBlockState(portalblock.west())).booleanValue()) {
            portalblock = portalblock.west().immutable();
        }
        if (!Util.isPortalOrObsidian(world.getBlockState(portalblock.west())).booleanValue()) {
            returnblocks.add(portalblock.west().below().immutable());
            if (!smallest) {
                returnblocks.add(portalblock.west().south().below().immutable());
            }
        } else {
            returnblocks.add(portalblock.south().below().immutable());
            if (!smallest) {
                returnblocks.add(portalblock.south().east().below().immutable());
            }
        }
        return returnblocks;
    }

    public static BlockPos findPortalAround(Level world, BlockPos pos) {
        BlockPos portalpos = null;
        for (int i = 0; i < 10; ++i) {
            BlockPos cpos = pos.above(i).immutable();
            Iterator around = BlockPos.betweenClosedStream((int)(cpos.getX() - 1), (int)cpos.getY(), (int)(cpos.getZ() - 1), (int)(cpos.getX() + 1), (int)cpos.getY(), (int)(cpos.getZ() + 1)).iterator();
            while (around.hasNext()) {
                BlockPos ap = (BlockPos)around.next();
                if (!Util.isPortal(world.getBlockState(ap)).booleanValue()) continue;
                portalpos = ap.immutable();
                break;
            }
            if (portalpos != null) break;
        }
        return portalpos;
    }

    public static void setObsidian(Level world, List<BlockPos> toblocks) {
        for (BlockPos tbs : toblocks) {
            if (Util.shouldMakeFront(world.getBlockState(tbs)).booleanValue()) {
                world.setBlockAndUpdate(tbs, Blocks.OBSIDIAN.defaultBlockState());
            }
            for (int i = 1; i < 3; ++i) {
                BlockPos up = tbs.above(i);
                if (Util.isAir(world.getBlockState(up)).booleanValue()) continue;
                world.setBlockAndUpdate(up, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public static Boolean shouldMakeFront(BlockState bs) {
        Block block = bs.getBlock();
        return Util.isAir(block) != false || block.equals(Blocks.NETHERRACK) || block.equals(Blocks.SOUL_SAND);
    }

    public static Boolean isObsidian(BlockState bs) {
        return Util.isObsidian(bs.getBlock());
    }

    public static Boolean isObsidian(Block block) {
        return block.equals(Blocks.OBSIDIAN) || Services.MODLOADER.isModLoaded("cryingportals") && block.equals(Blocks.CRYING_OBSIDIAN);
    }

    public static Boolean isAir(BlockState bs) {
        Block block = bs.getBlock();
        return block.equals(Blocks.AIR) || block.equals(Blocks.FIRE);
    }

    public static Boolean isAir(Block block) {
        return block.equals(Blocks.AIR) || block.equals(Blocks.FIRE);
    }

    public static Boolean isPortalOrObsidian(BlockState bs) {
        Block block = bs.getBlock();
        return block.equals(Blocks.NETHER_PORTAL) || Util.isObsidian(block) != false;
    }

    public static Boolean isPortal(BlockState bs) {
        Block block = bs.getBlock();
        return block.equals(Blocks.NETHER_PORTAL);
    }
}

