/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.extractpoison_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.extractpoison_common_neoforge.config.ConfigHandler;
import java.time.Duration;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.entity.animal.fish.Pufferfish;
import net.minecraft.world.entity.monster.spider.CaveSpider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;

public class PoisonEvent {
    private static final Map<UUID, LocalTime> lastuse = new HashMap<UUID, LocalTime>();

    public static InteractionResult onEntityInteract(Player player, Level world, InteractionHand hand, Entity target, EntityHitResult hitResult) {
        String entityname;
        if (world.isClientSide()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem().equals(Items.GLASS_BOTTLE) && ((entityname = EntityFunctions.getEntityString((Entity)target).toLowerCase()).contains("cavespider") || target instanceof CaveSpider || target instanceof Bee)) {
            LocalTime lastnow;
            int msbetween;
            LocalTime now = LocalTime.now();
            UUID targetuuid = target.getUUID();
            if (lastuse.containsKey(targetuuid) && (msbetween = (int)Duration.between(lastnow = lastuse.get(targetuuid), now).toMillis()) < ConfigHandler.extractDelayMs) {
                return InteractionResult.PASS;
            }
            ItemStack poison = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.POISON);
            ItemFunctions.shrinkGiveOrDropItemStack((Player)player, (InteractionHand)hand, (ItemStack)itemstack, (ItemStack)poison);
            lastuse.put(targetuuid, now);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onWaterClick(Player player, Level world, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (world.isClientSide()) {
            return InteractionResult.PASS;
        }
        if (itemstack.getItem().equals(Items.GLASS_BOTTLE)) {
            LocalTime now = LocalTime.now();
            BlockPos pos = player.blockPosition();
            List entitiesaround = world.getEntities((Entity)player, new AABB((double)(pos.getX() - 4), (double)(pos.getY() - 4), (double)(pos.getZ() - 4), (double)(pos.getX() + 4), (double)(pos.getY() + 4), (double)(pos.getZ() + 4)));
            for (Entity ea : entitiesaround) {
                LocalTime lastnow;
                int msbetween;
                UUID targetuuid;
                if (!(ea instanceof Pufferfish) || lastuse.containsKey(targetuuid = ea.getUUID()) && (msbetween = (int)Duration.between(lastnow = lastuse.get(targetuuid), now).toMillis()) < ConfigHandler.extractDelayMs) continue;
                ItemStack poison = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.POISON);
                ItemFunctions.shrinkGiveOrDropItemStack((Player)player, (InteractionHand)hand, (ItemStack)itemstack, (ItemStack)poison);
                lastuse.put(targetuuid, now);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }
}

