/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.hoetweaks_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.BlockFunctions;
import com.natamus.collective_common_neoforge.functions.CompareBlockFunctions;
import com.natamus.hoetweaks_common_neoforge.config.ConfigHandler;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;

public class Util {
    public static int getHoeRange(Level level, ItemStack hoeStack) {
        Identifier resourceLocation = level.registryAccess().lookupOrThrow(Registries.ITEM).getKey((Object)hoeStack.getItem());
        if (resourceLocation == null) {
            return ConfigHandler.woodenTierHoeRange;
        }
        String itemPath = resourceLocation.getPath();
        int range = ConfigHandler.woodenTierHoeRange;
        if (itemPath.startsWith("stone")) {
            range = ConfigHandler.stoneTierHoeRange;
        } else if (itemPath.startsWith("gold")) {
            range = ConfigHandler.goldTierHoeRange;
        } else if (itemPath.startsWith("iron") || itemPath.startsWith("steel")) {
            range = ConfigHandler.ironTierHoeRange;
        } else if (itemPath.startsWith("diamond")) {
            range = ConfigHandler.diamondTierHoeRange;
        } else if (itemPath.startsWith("netherite")) {
            range = ConfigHandler.netheriteTierHoeRange;
        }
        return range;
    }

    public static int processSoilGetDamage(Level world, BlockPos pos, int range, Block blocktoset, boolean checkforfarmland) {
        int damage = 0;
        Iterator blockstotill = BlockPos.betweenClosedStream((int)(pos.getX() - range), (int)pos.getY(), (int)(pos.getZ() - range), (int)(pos.getX() + range), (int)pos.getY(), (int)(pos.getZ() + range)).iterator();
        while (blockstotill.hasNext()) {
            BlockPos apos = (BlockPos)blockstotill.next();
            Block ablock = world.getBlockState(apos).getBlock();
            if (!checkforfarmland && !CompareBlockFunctions.isDirtBlock((Block)ablock) || checkforfarmland && !ablock.equals(Blocks.FARMLAND)) continue;
            BlockPos posabove = apos.above();
            Block blockabove = world.getBlockState(posabove).getBlock();
            if (blockabove instanceof BushBlock) {
                BlockFunctions.dropBlock((Level)world, (BlockPos)posabove);
            } else if (!blockabove.equals(Blocks.AIR)) continue;
            world.setBlock(apos, blocktoset.defaultBlockState(), 3);
            ++damage;
        }
        return damage;
    }
}

