/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.grassseeds_common_neoforge.events;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GrassEvent {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean onDirtClick(Level world, Player player, InteractionHand hand, BlockPos cpos, BlockHitResult hitVec) {
        if (world.isClientSide()) {
            return true;
        }
        ItemStack handstack = player.getItemInHand(hand);
        if (!handstack.getItem().equals(Items.WHEAT_SEEDS)) {
            return true;
        }
        Block block = world.getBlockState(cpos).getBlock();
        if (block.equals(Blocks.DIRT)) {
            world.setBlockAndUpdate(cpos, Blocks.GRASS_BLOCK.defaultBlockState());
        } else if (block.equals(Blocks.GRASS_BLOCK)) {
            BlockPos up = cpos.above();
            if (world.getBlockState(up).getBlock().equals(Blocks.AIR)) {
                world.setBlockAndUpdate(up, Blocks.SHORT_GRASS.defaultBlockState());
            } else {
                if (!world.getBlockState(up).getBlock().equals(Blocks.SHORT_GRASS)) return true;
                GrassEvent.upgradeGrass(world, up);
            }
        } else {
            if (!block.equals(Blocks.SHORT_GRASS)) return true;
            GrassEvent.upgradeGrass(world, cpos);
        }
        if (player.isCreative()) return true;
        handstack.shrink(1);
        return true;
    }

    private static void upgradeGrass(Level world, BlockPos pos) {
        DoublePlantBlock blockdoubleplant = (DoublePlantBlock)Blocks.TALL_GRASS;
        BlockState doubleplantstate = blockdoubleplant.defaultBlockState();
        if (doubleplantstate.canSurvive((LevelReader)world, pos) && world.isEmptyBlock(pos.above())) {
            world.setBlock(pos, (BlockState)blockdoubleplant.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
            world.setBlock(pos.above(), (BlockState)blockdoubleplant.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        }
    }
}

