/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.shadowed.blue.endless.jankson;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import squeek.appleskin.shadowed.blue.endless.jankson.JsonArray;
import squeek.appleskin.shadowed.blue.endless.jankson.JsonElement;
import squeek.appleskin.shadowed.blue.endless.jankson.JsonGrammar;
import squeek.appleskin.shadowed.blue.endless.jankson.JsonNull;
import squeek.appleskin.shadowed.blue.endless.jankson.JsonPrimitive;
import squeek.appleskin.shadowed.blue.endless.jankson.api.Marshaller;
import squeek.appleskin.shadowed.blue.endless.jankson.impl.MarshallerImpl;
import squeek.appleskin.shadowed.blue.endless.jankson.impl.serializer.CommentSerializer;

public class JsonObject
extends JsonElement
implements Map<String, JsonElement> {
    private static final Predicate<String> CAN_BE_UNQUOTED = Pattern.compile("^[a-zA-Z0-9]+$").asPredicate();
    protected Marshaller marshaller = MarshallerImpl.getFallback();
    private List<Entry> entries = new ArrayList<Entry>();

    @Nullable
    public JsonObject getObject(@Nonnull String name) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            if (entry.value instanceof JsonObject) {
                return (JsonObject)entry.value;
            }
            return null;
        }
        return null;
    }

    public JsonElement put(@Nonnull String key, @Nonnull JsonElement elem, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            JsonElement result = entry.value;
            entry.value = elem;
            entry.setComment(comment);
            return result;
        }
        Entry entry = new Entry();
        if (elem instanceof JsonObject) {
            ((JsonObject)elem).marshaller = this.marshaller;
        }
        if (elem instanceof JsonArray) {
            ((JsonArray)elem).marshaller = this.marshaller;
        }
        entry.key = key;
        entry.value = elem;
        entry.setComment(comment);
        this.entries.add(entry);
        return null;
    }

    @Nonnull
    public JsonElement putDefault(@Nonnull String key, @Nonnull JsonElement elem, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            return entry.value;
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = elem;
        entry.setComment(comment);
        this.entries.add(entry);
        return elem;
    }

    @Nullable
    public <T> T putDefault(@Nonnull String key, @Nonnull T elem, @Nullable String comment) {
        return this.putDefault(key, elem, elem.getClass(), comment);
    }

    @Nullable
    public <T> T putDefault(@Nonnull String key, @Nonnull T elem, Class<? extends T> clazz, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            return this.marshaller.marshall(clazz, entry.value);
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = this.marshaller.serialize(elem);
        if (entry.value == null) {
            entry.value = JsonNull.INSTANCE;
        }
        entry.setComment(comment);
        this.entries.add(entry);
        return elem;
    }

    @Nonnull
    public JsonObject getDelta(@Nonnull JsonObject defaults) {
        JsonObject result = new JsonObject();
        for (Entry entry : this.entries) {
            String key = entry.key;
            JsonElement defaultValue = defaults.get(key);
            if (defaultValue == null) {
                result.put(entry.key, entry.value, entry.getComment());
                continue;
            }
            if (entry.value instanceof JsonObject && defaultValue instanceof JsonObject) {
                JsonObject subDelta = ((JsonObject)entry.value).getDelta((JsonObject)defaultValue);
                if (subDelta.isEmpty()) continue;
                result.put(entry.key, subDelta, entry.getComment());
                continue;
            }
            if (entry.value.equals(defaultValue)) continue;
            result.put(entry.key, entry.value, entry.getComment());
        }
        return result;
    }

    @Nullable
    public String getComment(@Nonnull String name) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            return entry.getComment();
        }
        return null;
    }

    public void setComment(@Nonnull String name, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            entry.setComment(comment);
            return;
        }
    }

    @Override
    public String toJson(boolean comments, boolean newlines, int depth) {
        JsonGrammar grammar = JsonGrammar.builder().withComments(comments).printWhitespace(newlines).build();
        return this.toJson(grammar, depth);
    }

    @Override
    public void toJson(Writer w, JsonGrammar grammar, int depth) throws IOException {
        int nextDepth;
        boolean skipBraces = depth == 0 && grammar.bareRootObject;
        int effectiveDepth = grammar.bareRootObject ? depth - 1 : depth;
        int n = nextDepth = grammar.bareRootObject ? depth : depth + 1;
        if (!skipBraces) {
            w.append("{");
            if (grammar.printWhitespace && this.entries.size() > 0) {
                w.append('\n');
            } else {
                w.append(' ');
            }
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean quoted;
            Entry entry = this.entries.get(i);
            if (grammar.printWhitespace) {
                for (int j = 0; j < nextDepth; ++j) {
                    w.append("\t");
                }
            }
            CommentSerializer.print(w, entry.getComment(), effectiveDepth, grammar);
            boolean bl = quoted = !grammar.printUnquotedKeys;
            if (!CAN_BE_UNQUOTED.test(entry.key)) {
                quoted = true;
            }
            if (quoted) {
                w.append("\"");
            }
            w.append(entry.key);
            if (quoted) {
                w.append("\"");
            }
            w.append(": ");
            w.append(entry.value.toJson(grammar, depth + 1));
            if (grammar.printCommas) {
                if (i < this.entries.size() - 1 || grammar.printTrailingCommas) {
                    w.append(",");
                    if (i < this.entries.size() - 1 && !grammar.printWhitespace) {
                        w.append(' ');
                    }
                }
            } else if (!grammar.printWhitespace) {
                w.append(" ");
            }
            if (!grammar.printWhitespace) continue;
            w.append('\n');
        }
        if (!skipBraces) {
            if (this.entries.size() > 0) {
                if (grammar.printWhitespace) {
                    for (int j = 0; j < effectiveDepth; ++j) {
                        w.append("\t");
                    }
                } else {
                    w.append(' ');
                }
            }
            w.append("}");
        }
    }

    public String toString() {
        return this.toJson(true, false, 0);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof JsonObject)) {
            return false;
        }
        JsonObject otherObject = (JsonObject)other;
        if (this.entries.size() != otherObject.entries.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry b;
            Entry a = this.entries.get(i);
            if (a.equals(b = otherObject.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Nullable
    public <E> E get(@Nonnull Class<E> clazz, @Nonnull String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        JsonElement elem = this.get(key);
        return this.marshaller.marshall(clazz, elem);
    }

    public boolean getBoolean(@Nonnull String key, boolean defaultValue) {
        JsonElement elem = this.get(key);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asBoolean(defaultValue);
        }
        return defaultValue;
    }

    public byte getByte(@Nonnull String key, byte defaultValue) {
        JsonElement elem = this.get(key);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asByte(defaultValue);
        }
        return defaultValue;
    }

    public char getChar(@Nonnull String key, char defaultValue) {
        JsonElement elem = this.get(key);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asChar(defaultValue);
        }
        return defaultValue;
    }

    public short getShort(@Nonnull String key, short defaultValue) {
        JsonElement elem = this.get(key);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asShort(defaultValue);
        }
        return defaultValue;
    }

    public int getInt(@Nonnull String key, int defaultValue) {
        JsonElement elem = this.get(key);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asInt(defaultValue);
        }
        return defaultValue;
    }

    public long getLong(@Nonnull String key, long defaultValue) {
        JsonElement elem = this.get(key);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asLong(defaultValue);
        }
        return defaultValue;
    }

    public float getFloat(@Nonnull String key, float defaultValue) {
        JsonElement elem = this.get(key);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asFloat(defaultValue);
        }
        return defaultValue;
    }

    public double getDouble(@Nonnull String key, double defaultValue) {
        JsonElement elem = this.get(key);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asDouble(defaultValue);
        }
        return defaultValue;
    }

    @Nullable
    public <E> E recursiveGet(@Nonnull Class<E> clazz, @Nonnull String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        String[] parts = key.split("\\.");
        JsonObject cur = this;
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (s.isEmpty()) {
                throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
            }
            JsonElement elem = cur.get(s);
            if (i < parts.length - 1) {
                if (!(elem instanceof JsonObject)) {
                    return null;
                }
            } else {
                return this.marshaller.marshall(clazz, elem);
            }
            cur = (JsonObject)elem;
        }
        throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
    }

    public <E extends JsonElement> E recursiveGetOrCreate(@Nonnull Class<E> clazz, @Nonnull String key, @Nonnull E fallback, @Nullable String comment) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        String[] parts = key.split("\\.");
        JsonObject cur = this;
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (s.isEmpty()) {
                throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
            }
            JsonElement elem = cur.get(s);
            if (i < parts.length - 1) {
                if (elem instanceof JsonObject) {
                    cur = (JsonObject)elem;
                    continue;
                }
                JsonObject replacement = new JsonObject();
                cur.put(s, replacement);
                cur = replacement;
                continue;
            }
            if (elem != null && clazz.isAssignableFrom(elem.getClass())) {
                return (E)elem;
            }
            JsonElement result = fallback.clone();
            cur.put(s, result, comment);
            return (E)result;
        }
        throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
    }

    @Override
    public JsonObject clone() {
        JsonObject result = new JsonObject();
        for (Entry entry : this.entries) {
            result.put(entry.key, entry.value.clone(), entry.comment);
        }
        result.marshaller = this.marshaller;
        return result;
    }

    @Override
    @Nullable
    public JsonElement put(@Nonnull String key, @Nonnull JsonElement elem) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            JsonElement result = entry.value;
            entry.value = elem;
            return result;
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = elem;
        this.entries.add(entry);
        return null;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        if (!(key instanceof String)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase((String)key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object val) {
        if (val == null) {
            return false;
        }
        if (!(val instanceof JsonElement)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.value.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, JsonElement>> entrySet() {
        LinkedHashSet<Map.Entry<String, JsonElement>> result = new LinkedHashSet<Map.Entry<String, JsonElement>>();
        for (final Entry entry : this.entries) {
            result.add(new Map.Entry<String, JsonElement>(){

                @Override
                public String getKey() {
                    return entry.key;
                }

                @Override
                public JsonElement getValue() {
                    return entry.value;
                }

                @Override
                public JsonElement setValue(JsonElement value) {
                    JsonElement oldValue = entry.value;
                    entry.value = value;
                    return oldValue;
                }
            });
        }
        return result;
    }

    @Override
    @Nullable
    public JsonElement get(@Nullable Object key) {
        if (key == null || !(key instanceof String)) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase((String)key)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (Entry entry : this.entries) {
            keys.add(entry.key);
        }
        return keys;
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonElement> map) {
        for (Map.Entry<? extends String, ? extends JsonElement> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Nullable
    public JsonElement remove(@Nullable Object key) {
        if (key == null || !(key instanceof String)) {
            return null;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (!entry.key.equalsIgnoreCase((String)key)) continue;
            return this.entries.remove((int)i).value;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<JsonElement> values() {
        ArrayList<JsonElement> values = new ArrayList<JsonElement>();
        for (Entry entry : this.entries) {
            values.add(entry.value);
        }
        return values;
    }

    private static final class Entry {
        private String comment;
        protected String key;
        protected JsonElement value;

        private Entry() {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Entry)) {
                return false;
            }
            Entry o = (Entry)other;
            if (!Objects.equals(this.comment, o.comment)) {
                return false;
            }
            if (!this.key.equals(o.key)) {
                return false;
            }
            return this.value.equals(o.value);
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.key, this.value);
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment != null && !comment.trim().isEmpty() ? comment : null;
        }
    }
}

