/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.stickyenchantinglapis_common_neoforge.util;

import com.natamus.stickyenchantinglapis_common_neoforge.data.Variables;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;

public class Util {
    public static EnchantingTableBlockEntity getEnchantingTableBlockEntity(Player player) {
        if (player != null) {
            BlockEntity blockEntity;
            Level level = player.level();
            UUID playerUUID = player.getUUID();
            BlockPos enchantingTableBlockPos = null;
            if (Variables.lastEnchantingTableInteraction.containsKey(playerUUID)) {
                enchantingTableBlockPos = Variables.lastEnchantingTableInteraction.get(playerUUID).immutable();
            } else {
                BlockPos playerPos = player.blockPosition();
                for (BlockPos blockPos : BlockPos.betweenClosed((int)(playerPos.getX() - 8), (int)(playerPos.getY() - 8), (int)(playerPos.getZ() - 8), (int)(playerPos.getX() + 8), (int)(playerPos.getY() + 8), (int)(playerPos.getZ() + 8))) {
                    if (!(level.getBlockState(blockPos).getBlock() instanceof EnchantingTableBlock)) continue;
                    enchantingTableBlockPos = blockPos.immutable();
                    break;
                }
            }
            if (enchantingTableBlockPos != null && (blockEntity = level.getBlockEntity(enchantingTableBlockPos)) instanceof EnchantingTableBlockEntity) {
                EnchantingTableBlockEntity enchantingTableBlockEntity = (EnchantingTableBlockEntity)blockEntity;
                return enchantingTableBlockEntity;
            }
        }
        return null;
    }

    public static void saveLapisCount(Level level, EnchantingTableBlockEntity enchantingTableBlockEntity, int lapisCount) {
        DataComponentMap dataComponentMap = enchantingTableBlockEntity.components();
        DataComponentMap.Builder dataComponentMapBuilder = DataComponentMap.builder().addAll(dataComponentMap);
        if (lapisCount <= 0) {
            dataComponentMapBuilder.set(DataComponents.MAX_STACK_SIZE, null);
        } else {
            dataComponentMapBuilder.set(DataComponents.MAX_STACK_SIZE, (Object)lapisCount);
        }
        enchantingTableBlockEntity.setComponents(dataComponentMapBuilder.build());
        enchantingTableBlockEntity.setChanged();
    }

    public static int getLapisCount(Level level, EnchantingTableBlockEntity enchantingTableBlockEntity) {
        DataComponentMap dataComponentMap = enchantingTableBlockEntity.components();
        if (dataComponentMap.has(DataComponents.MAX_STACK_SIZE)) {
            return (Integer)dataComponentMap.get(DataComponents.MAX_STACK_SIZE);
        }
        return 0;
    }
}

