/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.sodiumcoreshadersupport.mixin.client;

import de.linusdev.sodiumcoreshadersupport.Constants;
import de.linusdev.sodiumcoreshadersupport.SodiumCoreShaderSupportClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.gl.shader.GlShader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderConstants;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderLoader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ShaderLoader.class})
public class MixinShaderLoader {
    @Inject(at={@At(value="HEAD")}, method={"loadShader"})
    private static void loadShaderInject(ShaderType type, class_2960 name, ShaderConstants constants, CallbackInfoReturnable<GlShader> cir) {
        Constants.LOG.info("Start loading shader in namespace '" + name.method_12836() + "': " + name.method_12832());
    }

    @Overwrite
    public static String getShaderSource(class_2960 name) {
        if (SodiumCoreShaderSupportClient.shaders == null) {
            String string;
            block14: {
                Constants.LOG.warn("Trying to load shaders, but shaders variable not yet initialised");
                String path = String.format("/assets/%s/shaders/%s", name.method_12836(), name.method_12832());
                InputStream in = ShaderLoader.class.getResourceAsStream(path);
                try {
                    if (in == null) {
                        throw new RuntimeException("Shader not found: " + path);
                    }
                    string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read shader source for " + path, e);
                    }
                }
                in.close();
            }
            return string;
        }
        Map<String, class_3298> nameSpace = SodiumCoreShaderSupportClient.shaders.get(name.method_12836());
        if (nameSpace == null) {
            throw new RuntimeException("No Shaders available for namespace '" + name.method_12836() + "'");
        }
        class_3298 shaderResource = nameSpace.get(name.method_12832());
        if (shaderResource == null) {
            throw new RuntimeException("No Shader found in namespace '" + name.method_12836() + "' for shader '" + name.method_12832() + "'");
        }
        try {
            Constants.LOG.info("Loaded Shader '{}:{}' from pack '{}'.", new Object[]{name.method_12836(), name.method_12832(), shaderResource.method_45304().method_56926().comp_2330().getString()});
            return IOUtils.toString((InputStream)shaderResource.method_14482(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while reading shader source in namespace '" + name.method_12836() + "' for shader '" + name.method_12832() + "'", e);
        }
    }
}

