/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.quickrightclick_common_forge.features;

import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.quickrightclick_common_forge.config.ConfigHandler;
import com.natamus.quickrightclick_common_forge.data.Variables;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.attribute.BedRule;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class BedBlockFeature {
    public static boolean init(Level level, Player player, BlockPos playerPos, ItemStack handStack, InteractionHand hand, Block block) {
        if (!ConfigHandler.enableQuickBeds) {
            return false;
        }
        BedRule bedrule = (BedRule)level.environmentAttributes().getValue(EnvironmentAttributes.BED_RULE, playerPos);
        if (bedrule.explodes()) {
            return false;
        }
        BlockPos bedPos = playerPos.immutable();
        if (!(level.getBlockState(bedPos).getBlock().equals(Blocks.AIR) || level.getBlockState(bedPos = bedPos.above().immutable()).getBlock().equals(Blocks.AIR) && level.getBlockState(bedPos.north()).getBlock().equals(Blocks.AIR))) {
            if (level.isClientSide()) {
                MessageFunctions.sendMessage((Player)player, (String)"Unable to sleep, location obstructed.", (ChatFormatting)ChatFormatting.DARK_GRAY);
            }
            return false;
        }
        level.setBlock(bedPos.north(), (BlockState)block.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD), 3);
        level.setBlock(bedPos, (BlockState)block.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT), 3);
        if (!level.isClientSide()) {
            String playerName = player.getName().getString();
            Variables.bedIsSleeping.add(playerName);
            AtomicBoolean canSleep = new AtomicBoolean(true);
            player.startSleepInBed(bedPos.north()).ifLeft(bedSleepingProblem -> {
                if (bedSleepingProblem.message() != null) {
                    player.displayClientMessage(bedSleepingProblem.message(), true);
                    canSleep.set(false);
                }
            });
            if (!canSleep.get()) {
                level.setBlock(bedPos.north(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(bedPos, Blocks.AIR.defaultBlockState(), 3);
                Variables.bedIsSleeping.remove(playerName);
                return false;
            }
            if (!player.isCreative()) {
                handStack.shrink(1);
            }
            Variables.bedUsedHand.put(playerName, hand);
        }
        return true;
    }
}

