/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors_common_fabric.util;

import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.doubledoors_common_fabric.config.ConfigHandler;
import java.io.File;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2440;
import net.minecraft.class_2533;
import net.minecraft.class_2557;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;

public class Util {
    public static boolean isDoorBlock(class_2680 blockState) {
        return Util.isDoorBlock(blockState.method_26204());
    }

    public static boolean isDoorBlock(class_2248 block) {
        return block instanceof class_2323 && ConfigHandler.enableDoors || block instanceof class_2533 && ConfigHandler.enableTrapdoors || block instanceof class_2349 && ConfigHandler.enableFenceGates;
    }

    public static boolean isPressureBlock(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2557) {
            return (Integer)blockState.method_11654((class_2769)class_2741.field_12511) > 0;
        }
        if (block instanceof class_2440 || block instanceof class_2269) {
            return (Boolean)blockState.method_11654((class_2769)class_2741.field_12484);
        }
        return false;
    }

    public static boolean processDoor(class_1657 player, class_1937 level, class_2338 blockPos, class_2680 blockState, Boolean isOpen) {
        List<class_2338> posToOpenList;
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2323 && ((class_2756)blockState.method_11654((class_2769)class_2323.field_10946)).equals((Object)class_2756.field_12609)) {
            blockPos = blockPos.method_10074().method_10062();
            blockState = level.method_8320(blockPos);
        }
        if (!blockState.method_28498((class_2769)class_2741.field_12537)) {
            return false;
        }
        if (isOpen == null) {
            isOpen = (Boolean)blockState.method_11654((class_2769)class_2741.field_12537);
        }
        class_2350 facing = null;
        if (block instanceof class_2349) {
            facing = (class_2350)blockState.method_11654((class_2769)class_2349.field_11177);
        }
        int yOffset = 0;
        if (!(block instanceof class_2323)) {
            yOffset = 1;
        }
        if ((posToOpenList = Util.recursivelyOpenDoors(new ArrayList<class_2338>(Arrays.asList(blockPos.method_10062())), new ArrayList<class_2338>(), level, blockPos, blockPos, block, yOffset)).size() <= 1) {
            return false;
        }
        for (class_2338 toOpenBlockPos : posToOpenList) {
            class_2248 class_22482;
            if (toOpenBlockPos.equals((Object)blockPos)) continue;
            class_2680 oBlockState = level.method_8320(toOpenBlockPos);
            class_2248 oBlock = oBlockState.method_26204();
            Objects.requireNonNull(block);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2323.class, class_2533.class, class_2349.class}, (Object)class_22482, n)) {
                case 0: {
                    class_2323 doorBlock = (class_2323)class_22482;
                    if (!ConfigHandler.enableDoors) break;
                    level.method_8652(toOpenBlockPos, (class_2680)oBlockState.method_11657((class_2769)class_2323.field_10945, (Comparable)isOpen), 10);
                    break;
                }
                case 1: {
                    class_2533 trapDoorBlock = (class_2533)class_22482;
                    if (!ConfigHandler.enableTrapdoors) break;
                    level.method_8652(toOpenBlockPos, (class_2680)oBlockState.method_11657((class_2769)class_2741.field_12537, (Comparable)isOpen), 10);
                    break;
                }
                case 2: {
                    class_2350 oFacing;
                    class_2349 fenceGateBlock = (class_2349)class_22482;
                    if (!ConfigHandler.enableFenceGates || !(oFacing = (class_2350)oBlockState.method_11654((class_2769)class_2349.field_11177)).equals((Object)facing) && !oFacing.method_10153().equals((Object)facing)) break;
                    level.method_8652(toOpenBlockPos, (class_2680)((class_2680)oBlockState.method_11657((class_2769)class_2323.field_10945, (Comparable)isOpen)).method_11657((class_2769)class_2349.field_11177, (Comparable)facing), 10);
                    break;
                }
            }
        }
        if (player != null) {
            player.method_6104(class_1268.field_5808);
        }
        return posToOpenList.size() > 1;
    }

    private static List<class_2338> recursivelyOpenDoors(List<class_2338> posToOpenList, List<class_2338> ignoreOpenList, class_1937 level, class_2338 originalBlockPos, class_2338 blockPos, class_2248 block, int yOffset) {
        Iterator blocksaround = class_2338.method_17962((int)(blockPos.method_10263() - 1), (int)(blockPos.method_10264() - yOffset), (int)(blockPos.method_10260() - 1), (int)(blockPos.method_10263() + 1), (int)(blockPos.method_10264() + yOffset), (int)(blockPos.method_10260() + 1)).iterator();
        while (blocksaround.hasNext()) {
            class_2338 bpa = (class_2338)blocksaround.next();
            if (posToOpenList.contains(bpa) || !BlockPosFunctions.withinDistance((class_2338)originalBlockPos, (class_2338)bpa, (int)ConfigHandler.recursiveOpeningMaxBlocksDistance).booleanValue()) continue;
            class_2680 oBlockState = level.method_8320(bpa);
            class_2248 oBlock = oBlockState.method_26204();
            if (Util.isDoorBlock(oBlockState) && oBlock.method_9518().equals((Object)block.method_9518())) {
                posToOpenList.add(bpa.method_10062());
                if (!ConfigHandler.enableRecursiveOpening) continue;
                Util.recursivelyOpenDoors(posToOpenList, ignoreOpenList, level, originalBlockPos, bpa, block, yOffset);
                continue;
            }
            ignoreOpenList.add(bpa.method_10062());
        }
        return posToOpenList;
    }

    public static void checkForOtherModdedDoubleDoorFunctionality() {
        block17: {
            if (!ConfigHandler.enableModIncompatibilityCheck) {
                return;
            }
            try {
                if (!Services.MODLOADER.isModLoaded("quark")) break block17;
                String quarkConfigPath = DataFunctions.getConfigDirectory() + File.separator + "quark-common.toml";
                File quarkConfig = new File(quarkConfigPath);
                if (quarkConfig.exists()) {
                    List<String> doorConfigKeys = Arrays.asList("\"Double Door Opening\"", "\"Enable Doors\"", "\"Enable Fence Gates\"");
                    String quarkConfigContent = Files.readString(Path.of(quarkConfigPath, new String[0]), StandardCharsets.UTF_8);
                    boolean writeOutput = false;
                    StringBuilder output = new StringBuilder();
                    for (String line : quarkConfigContent.split("\n")) {
                        if (!output.isEmpty()) {
                            output.append("\n");
                        }
                        for (String doorConfigKey : doorConfigKeys) {
                            if (!line.contains(doorConfigKey) || !line.contains("true")) continue;
                            line = line.replace("true", "false");
                            writeOutput = true;
                            break;
                        }
                        output.append(line);
                    }
                    if (!writeOutput) break block17;
                    try (PrintWriter printWriter = new PrintWriter(quarkConfigPath);){
                        printWriter.println(output);
                        break block17;
                    }
                }
                String quarkConfigIfNewInstance = "[tweaks]\n\t\"Double Door Opening\" = false\n\n\t[tweaks.double_door_opening]\n\t\t\"Enable Doors\" = false\n\t\t\"Enable Fence Gates\" = false\n\t\t\"Ignore Anti Overlap\" = false";
                try (PrintWriter printWriter = new PrintWriter(quarkConfigPath);){
                    printWriter.println(quarkConfigIfNewInstance);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

