/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.easyelevators_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.easyelevators_common_forge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ElevatorEvents {
    public static void onCrouch(Level level, Player player) {
        BlockPos belowElevator;
        if (level.isClientSide()) {
            return;
        }
        Pair<BlockPos, BlockPos> elevatorData = Util.getElevatorData(level, player, player.blockPosition());
        if (elevatorData != null && (belowElevator = (BlockPos)elevatorData.getSecond()) != null) {
            Vec3 finalElevatorVec = Util.getFinalElevatorVec(level, belowElevator, player.position());
            player.teleportTo((ServerLevel)level, finalElevatorVec.x, finalElevatorVec.y, finalElevatorVec.z, Relative.ROTATION, player.getYRot(), player.getXRot(), true);
        }
    }

    public static void onJump(Level level, Player player) {
        BlockPos aboveElevator;
        if (level.isClientSide()) {
            return;
        }
        Pair<BlockPos, BlockPos> elevatorData = Util.getElevatorData(level, player, player.blockPosition());
        if (elevatorData != null && (aboveElevator = (BlockPos)elevatorData.getFirst()) != null) {
            Vec3 finalElevatorVec = Util.getFinalElevatorVec(level, aboveElevator, player.position());
            player.teleportTo((ServerLevel)level, finalElevatorVec.x, finalElevatorVec.y, finalElevatorVec.z, Relative.ROTATION, player.getYRot(), player.getXRot(), true);
        }
    }
}

