/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.easyelevators_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.easyelevators_common_fabric.config.ConfigHandler;
import com.natamus.easyelevators_common_fabric.data.Variables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final List<class_2248> elevatorBlocks = new ArrayList<class_2248>();
    public static final List<class_2248> elevatorChains = new ArrayList<class_2248>();

    public static void processConfigBlocks(class_1937 level) {
        if (Variables.processedConfigBlocks) {
            return;
        }
        Variables.processedConfigBlocks = true;
        class_2378 blockRegistry = level.method_30349().method_30530(class_7924.field_41254);
        for (String rawElevatorBlock : ConfigHandler.elevatorBlocks.split(",")) {
            class_2248 elevatorBlock;
            Optional elevatorBlockOptionalReference;
            class_2960 rawElevatorBlockRL = class_2960.method_12829((String)rawElevatorBlock.strip());
            if (!blockRegistry.method_10250(rawElevatorBlockRL) || !(elevatorBlockOptionalReference = blockRegistry.method_10223(rawElevatorBlockRL)).isPresent() || elevatorBlocks.contains(elevatorBlock = (class_2248)((class_6880.class_6883)elevatorBlockOptionalReference.get()).comp_349())) continue;
            elevatorBlocks.add(elevatorBlock);
        }
        for (String rawElevatorChain : ConfigHandler.elevatorChains.split(",")) {
            class_2248 elevatorChain;
            Optional elevatorChainOptionalReference;
            class_2960 rawElevatorChainRL = class_2960.method_12829((String)rawElevatorChain.strip());
            if (!blockRegistry.method_10250(rawElevatorChainRL) || !(elevatorChainOptionalReference = blockRegistry.method_10223(rawElevatorChainRL)).isPresent() || elevatorChains.contains(elevatorChain = (class_2248)((class_6880.class_6883)elevatorChainOptionalReference.get()).comp_349())) continue;
            elevatorChains.add(elevatorChain);
        }
    }

    public static boolean isElevatorBlock(class_1937 level, class_2338 blockPos) {
        return Util.isElevatorBlock(level.method_8320(blockPos).method_26204());
    }

    public static boolean isElevatorBlock(class_2248 block) {
        return elevatorBlocks.contains(block);
    }

    public static boolean isElevatorChain(class_1937 level, class_2338 blockPos) {
        return Util.isElevatorChain(level.method_8320(blockPos).method_26204());
    }

    public static boolean isElevatorChain(class_2248 block) {
        return elevatorChains.contains(block);
    }

    public static Pair<class_2338, class_2338> getElevatorData(class_1937 level, class_1657 player, class_2338 blockPos) {
        class_2248 insideBlock = level.method_8320(blockPos).method_26204();
        if (!insideBlock.equals(class_2246.field_10124) && !Util.isElevatorChain(insideBlock)) {
            return null;
        }
        if (!Util.isElevatorBlock(level, blockPos.method_10074())) {
            return null;
        }
        class_2338 currentElevatorPos = blockPos.method_10074().method_10062();
        int elevatorSize = Util.calculateElevatorSize(level, currentElevatorPos);
        if (elevatorSize < ConfigHandler.minimumElevatorSize) {
            return null;
        }
        Object elevatorData = null;
        elevatorData = !ConfigHandler.elevatorMustBeConnectedViaChains ? Util.getChainlessElevatorAboveAndBelow(level, currentElevatorPos) : Util.getChainElevatorAboveAndBelow(level, Util.findChainPositionAbove(level, currentElevatorPos), Util.findChainPositionBelow(level, currentElevatorPos));
        if (elevatorData != null) {
            int belowSize;
            int aboveSize = elevatorData.getFirst() != null ? Util.calculateElevatorSize(level, (class_2338)elevatorData.getFirst()) : 0;
            int n = belowSize = elevatorData.getSecond() != null ? Util.calculateElevatorSize(level, (class_2338)elevatorData.getSecond()) : 0;
            if (aboveSize < ConfigHandler.minimumElevatorSize && belowSize < ConfigHandler.minimumElevatorSize) {
                return null;
            }
            elevatorData = Pair.of((Object)(aboveSize < ConfigHandler.minimumElevatorSize ? null : (class_2338)elevatorData.getFirst()), belowSize < ConfigHandler.minimumElevatorSize ? null : (class_2338)elevatorData.getSecond());
        }
        return elevatorData;
    }

    private static Pair<class_2338, class_2338> getChainElevatorAboveAndBelow(class_1937 level, @Nullable class_2338 aboveChain, @Nullable class_2338 belowChain) {
        return Pair.of((Object)Util.findChainElevator(level, aboveChain, true), (Object)Util.findChainElevator(level, belowChain, false));
    }

    private static Pair<class_2338, class_2338> getChainlessElevatorAboveAndBelow(class_1937 level, class_2338 elevatorPos) {
        return Pair.of((Object)Util.findChainlessElevator(level, elevatorPos, true), (Object)Util.findChainlessElevator(level, elevatorPos, false));
    }

    public static class_243 getFinalElevatorVec(class_1937 level, class_2338 elevatorPos, class_243 playerVec) {
        double z;
        double x = playerVec.field_1352;
        double y = elevatorPos.method_10264();
        if (!Util.isElevatorBlock(level, class_2338.method_49637((double)x, (double)y, (double)(z = playerVec.field_1350)))) {
            return new class_243((double)elevatorPos.method_10263(), y + 1.0, (double)elevatorPos.method_10260());
        }
        return new class_243(x, y + 1.0, z);
    }

    @Nullable
    private static class_2338 findChainPositionAbove(class_1937 level, class_2338 blockPos) {
        return Util.findChainPosition(level, blockPos, 0, 1);
    }

    @Nullable
    private static class_2338 findChainPositionBelow(class_1937 level, class_2338 blockPos) {
        return Util.findChainPosition(level, blockPos, 0, -1);
    }

    @Nullable
    private static class_2338 findChainPosition(class_1937 level, class_2338 blockPos, int ... yOffsets) {
        int size = ConfigHandler.maximumElevatorSize;
        int range = size % 2 == 0 ? size / 2 : (size - 1) / 2;
        for (int yOffset : yOffsets) {
            for (class_2338 aroundPos : class_2338.method_10094((int)(blockPos.method_10263() - 2), (int)(blockPos.method_10264() + yOffset), (int)(blockPos.method_10260() - 2), (int)(blockPos.method_10263() + 2), (int)(blockPos.method_10264() + yOffset), (int)(blockPos.method_10260() + 2))) {
                if (!Util.isElevatorChain(level, aroundPos)) continue;
                return aroundPos.method_10062();
            }
        }
        return null;
    }

    @Nullable
    private static class_2338 findChainElevator(class_1937 level, @Nullable class_2338 chainPos, boolean searchAbove) {
        class_2338 possibleElevatorPos;
        if (chainPos == null) {
            return null;
        }
        class_2338 currentChainPos = chainPos.method_10062();
        while (Util.isElevatorChain(level, searchAbove ? currentChainPos.method_10084() : currentChainPos.method_10074())) {
            currentChainPos = (searchAbove ? currentChainPos.method_10084() : currentChainPos.method_10074()).method_10062();
        }
        class_2338 class_23382 = possibleElevatorPos = searchAbove ? currentChainPos.method_10084() : currentChainPos.method_10074();
        if (Util.isElevatorBlock(level, possibleElevatorPos)) {
            return possibleElevatorPos.method_10062();
        }
        return null;
    }

    @Nullable
    private static class_2338 findChainlessElevator(class_1937 level, class_2338 elevatorPos, boolean searchAbove) {
        class_2338 currentPos = elevatorPos.method_10062();
        int direction = searchAbove ? 1 : -1;
        for (int i = 1; i <= ConfigHandler.maximumChainlessElevatorHeight; ++i) {
            class_2338 nextPos = currentPos.method_10069(0, i * direction, 0);
            if (!Util.isElevatorBlock(level, nextPos)) continue;
            return nextPos.method_10062();
        }
        return null;
    }

    public static int calculateElevatorSize(class_1937 level, class_2338 startPos) {
        class_2248 targetBlock = level.method_8320(startPos).method_26204();
        if (!Util.isElevatorBlock(level, startPos)) {
            return 0;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(startPos);
        visited.add(startPos);
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            for (class_2338 neighbor : new class_2338[]{current.method_10095(), current.method_10072(), current.method_10078(), current.method_10067()}) {
                if (visited.contains(neighbor) || !Util.isElevatorBlock(level, neighbor)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return Util.findLargestSquare(visited);
    }

    private static int findLargestSquare(Set<class_2338> visited) {
        int maxSize = 0;
        for (class_2338 pos : visited) {
            boolean squareFound;
            int size = 1;
            do {
                squareFound = true;
                for (int x = 0; x < size; ++x) {
                    for (int y = 0; y < size; ++y) {
                        class_2338 checkPos = pos.method_10069(x, 0, y);
                        if (visited.contains(checkPos)) continue;
                        squareFound = false;
                        break;
                    }
                    if (!squareFound) break;
                }
                if (!squareFound) continue;
                maxSize = Math.max(maxSize, size);
                ++size;
            } while (squareFound);
        }
        return maxSize;
    }
}

