/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.enchantmentlevelcapindicator_common_neoforge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import com.natamus.enchantmentlevelcapindicator_common_neoforge.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.IdentifierException;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class Util {
    @Nullable
    public static Pair<Enchantment, Integer> parseRawComponentText(Component component, Registry<Enchantment> enchantmentRegistry) {
        return Util.parseRawComponentText(component.toString(), enchantmentRegistry);
    }

    @Nullable
    public static Pair<Enchantment, Integer> parseRawComponentText(String rawText, Registry<Enchantment> enchantmentRegistry) {
        Enchantment enchantment;
        Identifier enchantmentIdentifier;
        String[] rawEnchSpl = rawText.split("enchantment.");
        if (rawEnchSpl.length < 2) {
            return null;
        }
        String rawEnchantment = rawEnchSpl[1].split("'")[0];
        try {
            enchantmentIdentifier = Identifier.parse((String)rawEnchantment.replace(".", ":"));
        }
        catch (IdentifierException ex) {
            return null;
        }
        int level = 1;
        if (rawEnchSpl.length > 2) {
            String rawEnchantmentLevel = rawEnchSpl[2].split("'")[0].replace("level.", "");
            if (!NumberFunctions.isNumeric((String)rawEnchantmentLevel)) {
                return null;
            }
            level = Integer.parseInt(rawEnchantmentLevel);
        }
        if ((enchantment = (Enchantment)enchantmentRegistry.getValue(enchantmentIdentifier)) == null) {
            return null;
        }
        return Pair.of((Object)enchantment, (Object)level);
    }

    public static Component getStarComponent() {
        ChatFormatting symbolColour = ChatFormatting.getById((int)ConfigHandler.maxLevelSymbolColourIndex);
        if (symbolColour == null) {
            symbolColour = ChatFormatting.GOLD;
        }
        return Component.literal((String)(" " + ConfigHandler.maxLevelSymbol)).withStyle(symbolColour);
    }
}

