/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferMapFlags;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferMapping;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferUsage;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlMutableBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.tessellation.GlIndexType;
import net.caffeinemc.mods.sodium.client.gl.util.EnumBitField;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;

public class SharedQuadIndexBuffer {
    private static final int ELEMENTS_PER_PRIMITIVE = 6;
    private static final int VERTICES_PER_PRIMITIVE = 4;
    private final GlMutableBuffer buffer;
    private final IndexType indexType;
    private int maxPrimitives;

    public SharedQuadIndexBuffer(CommandList commandList, IndexType indexType) {
        this.buffer = commandList.createMutableBuffer();
        this.indexType = indexType;
    }

    public void ensureCapacity(CommandList commandList, int elementCount) {
        if (elementCount > this.indexType.getMaxElementCount()) {
            throw new IllegalArgumentException("Tried to reserve storage for more vertices in this buffer than it can hold");
        }
        int primitiveCount = elementCount / 6;
        if (primitiveCount > this.maxPrimitives) {
            this.grow(commandList, this.getNextSize(primitiveCount));
        }
    }

    private int getNextSize(int primitiveCount) {
        return Math.min(Math.max(this.maxPrimitives * 2, primitiveCount + 16384), this.indexType.getMaxPrimitiveCount());
    }

    private void grow(CommandList commandList, int primitiveCount) {
        int bufferSize = primitiveCount * this.indexType.getBytesPerElement() * 6;
        commandList.allocateStorage(this.buffer, bufferSize, GlBufferUsage.STATIC_DRAW);
        GlBufferMapping mapped = commandList.mapBuffer(this.buffer, 0L, bufferSize, EnumBitField.of((Enum[])new GlBufferMapFlags[]{GlBufferMapFlags.INVALIDATE_BUFFER, GlBufferMapFlags.WRITE, GlBufferMapFlags.UNSYNCHRONIZED}));
        this.indexType.createIndexBuffer(mapped.getMemoryBuffer(), primitiveCount);
        commandList.unmap(mapped);
        this.maxPrimitives = primitiveCount;
    }

    public static NativeBuffer createIndexBuffer(IndexType indexType, int primitiveCount) {
        int bufferSize = primitiveCount * indexType.getBytesPerElement() * 6;
        NativeBuffer buffer = new NativeBuffer(bufferSize);
        indexType.createIndexBuffer(buffer.getDirectBuffer(), primitiveCount);
        return buffer;
    }

    public GlBuffer getBufferObject() {
        return this.buffer;
    }

    public void delete(CommandList commandList) {
        commandList.deleteBuffer(this.buffer);
    }

    public static enum IndexType {
        SHORT(GlIndexType.UNSIGNED_SHORT, 65536){

            @Override
            public void createIndexBuffer(ByteBuffer byteBuffer, int primitiveCount) {
                ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                for (int primitiveIndex = 0; primitiveIndex < primitiveCount; ++primitiveIndex) {
                    int indexOffset = primitiveIndex * 6;
                    int vertexOffset = primitiveIndex * 4;
                    shortBuffer.put(indexOffset + 0, (short)(vertexOffset + 0));
                    shortBuffer.put(indexOffset + 1, (short)(vertexOffset + 1));
                    shortBuffer.put(indexOffset + 2, (short)(vertexOffset + 2));
                    shortBuffer.put(indexOffset + 3, (short)(vertexOffset + 2));
                    shortBuffer.put(indexOffset + 4, (short)(vertexOffset + 3));
                    shortBuffer.put(indexOffset + 5, (short)(vertexOffset + 0));
                }
            }
        }
        ,
        INTEGER(GlIndexType.UNSIGNED_INT, Integer.MAX_VALUE){

            @Override
            public void createIndexBuffer(ByteBuffer byteBuffer, int primitiveCount) {
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                for (int primitiveIndex = 0; primitiveIndex < primitiveCount; ++primitiveIndex) {
                    int indexOffset = primitiveIndex * 6;
                    int vertexOffset = primitiveIndex * 4;
                    intBuffer.put(indexOffset + 0, vertexOffset + 0);
                    intBuffer.put(indexOffset + 1, vertexOffset + 1);
                    intBuffer.put(indexOffset + 2, vertexOffset + 2);
                    intBuffer.put(indexOffset + 3, vertexOffset + 2);
                    intBuffer.put(indexOffset + 4, vertexOffset + 3);
                    intBuffer.put(indexOffset + 5, vertexOffset + 0);
                }
            }
        };

        public static final IndexType[] VALUES;
        private final GlIndexType format;
        private final int maxElementCount;

        private IndexType(GlIndexType format, int maxElementCount) {
            this.format = format;
            this.maxElementCount = maxElementCount;
        }

        public abstract void createIndexBuffer(ByteBuffer var1, int var2);

        public int getBytesPerElement() {
            return this.format.getStride();
        }

        public GlIndexType getFormat() {
            return this.format;
        }

        public int getMaxPrimitiveCount() {
            return this.maxElementCount / 4;
        }

        public int getMaxElementCount() {
            return this.maxElementCount;
        }

        static {
            VALUES = IndexType.values();
        }
    }
}

