/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.widgets.ScrollbarWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.joml.Vector2i;
import org.jspecify.annotations.NonNull;

public class ScrollableTooltip {
    private static final class_2960 ARROW_TEXTURE = class_2960.method_60655((String)"sodium", (String)"textures/gui/tooltip_arrows.png");
    private static final int ARROW_WIDTH = 5;
    private static final int SPRITE_WIDTH = 10;
    private static final int ARROW_HEIGHT = 9;
    private static final int TEXT_HORIZONTAL_PADDING = 4;
    private static final int TEXT_VERTICAL_PADDING = 4;
    private final class_327 font;
    private ControlElement hoveredElement;
    private ScrollbarWidget scrollbar;
    private final Vector2i contentSize;
    private Dim2i visibleDim;
    private boolean overlayMode;
    private final List<class_5481> content;
    private final TooltipParent parent;
    private Dim2i tooltipArea;
    private final Vector2i reservedArea;

    public ScrollableTooltip(TooltipParent parent) {
        this.font = class_310.method_1551().field_1772;
        this.contentSize = new Vector2i();
        this.content = new ArrayList<class_5481>();
        this.reservedArea = new Vector2i();
        this.parent = parent;
    }

    public void setTooltipArea(Dim2i area) {
        this.tooltipArea = area;
    }

    public void onControlHover(ControlElement hovered, int mouseX, int mouseY) {
        if (hovered != null) {
            this.hoveredElement = hovered;
            if (this.scrollbar != null) {
                this.parent.method_37066(this.scrollbar);
                this.scrollbar = null;
            }
            if (this.positionTooltip(false)) {
                this.positionTooltip(true);
                this.scrollbar = this.parent.method_37063(new ScrollbarWidget(new Dim2i(this.visibleDim.getLimitX() - 7, this.visibleDim.y(), 7, this.visibleDim.height()), false, true));
                this.scrollbar.setScrollbarContext(this.visibleDim.height(), this.contentSize.y());
            }
        } else if (this.hoveredElement != null) {
            this.positionTooltip(this.scrollbar != null);
            if (!(mouseX >= this.hoveredElement.getLimitX() && mouseX < this.visibleDim.x() && mouseY >= this.hoveredElement.getY() && mouseY < this.hoveredElement.getLimitY() || this.visibleDim.containsCursor(mouseX, mouseY))) {
                this.hoveredElement = null;
                if (this.scrollbar != null) {
                    this.parent.method_37066(this.scrollbar);
                    this.scrollbar = null;
                }
            }
        }
    }

    private int getLineHeight() {
        Objects.requireNonNull(this.font);
        return 9 + 2;
    }

    private int generateTooltipContent(int boxWidth, boolean needsScrolling) {
        int textWidth = boxWidth - 8;
        if (needsScrolling) {
            textWidth -= 7;
        }
        Option option = this.hoveredElement.getOption();
        this.content.clear();
        this.content.addAll(this.font.method_1728((class_5348)option.getTooltip(), textWidth));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            class_5250 impactText = class_2561.method_43469((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getName()});
            this.content.addAll(this.font.method_1728((class_5348)impactText.method_27692(class_124.field_1080), textWidth));
        }
        return this.content.size() * this.getLineHeight() - 2 + 8;
    }

    private boolean positionTooltip(boolean needsScrolling) {
        int defaultBoxWidth = Math.min(this.tooltipArea.getLimitX() - this.tooltipArea.x(), 200);
        int defaultBoxY = this.hoveredElement.getY();
        int defaultBoxX = this.tooltipArea.x();
        int boxWidth = 0;
        int boxX = 0;
        int boxY = 0;
        boolean fixedBoxY = false;
        int boxYCutoff = this.tooltipArea.getLimitY();
        boolean bl = this.overlayMode = defaultBoxWidth < 100;
        if (!this.overlayMode) {
            if (this.hoveredElement.getLimitY() < this.reservedArea.y) {
                boxWidth = defaultBoxWidth;
                boxX = defaultBoxX;
                boxY = defaultBoxY;
                boxYCutoff = this.reservedArea.y;
            } else if (this.tooltipArea.x() < this.reservedArea.x) {
                int availableWidth = this.reservedArea.x - this.tooltipArea.x();
                if (availableWidth >= 100) {
                    boxWidth = Math.min(availableWidth, 200);
                    boxX = defaultBoxX;
                    boxY = defaultBoxY;
                } else {
                    this.overlayMode = true;
                }
            } else {
                boxWidth = defaultBoxWidth;
                boxX = defaultBoxX;
                boxY = defaultBoxY;
            }
        }
        if (this.overlayMode) {
            boxWidth = this.hoveredElement.getWidth() - 6;
            boxX = this.hoveredElement.getX() + 3;
            int spaceAbove = this.hoveredElement.getY() - this.tooltipArea.y();
            int spaceBelow = this.tooltipArea.getLimitY() - this.hoveredElement.getLimitY() - 3;
            if (spaceBelow >= spaceAbove) {
                boxY = this.hoveredElement.getLimitY() + 3;
                boxYCutoff = this.tooltipArea.getLimitY() - 3;
                fixedBoxY = true;
            } else {
                boxY = this.hoveredElement.getY() - 3;
                boxYCutoff = this.hoveredElement.getY() - 3;
            }
        }
        int contentHeight = this.generateTooltipContent(boxWidth, needsScrolling);
        int boxYLimit = boxY + contentHeight;
        if (!fixedBoxY) {
            if (boxYLimit > boxYCutoff) {
                boxY -= boxYLimit - boxYCutoff;
            }
            if (boxY < this.tooltipArea.y()) {
                boxY = this.tooltipArea.y();
            }
        }
        this.contentSize.set(boxWidth, contentHeight);
        int maxVisibleHeight = boxYCutoff - boxY;
        int visibleHeight = Math.min(contentHeight, maxVisibleHeight);
        this.visibleDim = new Dim2i(boxX, boxY, boxWidth, visibleHeight);
        return contentHeight > maxVisibleHeight;
    }

    public void render(@NonNull class_332 graphics) {
        if (this.hoveredElement == null) {
            return;
        }
        if (!this.overlayMode) {
            int arrowX = this.visibleDim.x() - 5;
            int arrowY = this.hoveredElement.getCenterY() - 4;
            arrowY = Math.max(arrowY, this.tooltipArea.y());
            arrowY = Math.min(arrowY + 9, this.tooltipArea.getLimitY()) - 9;
            graphics.method_71048();
            graphics.method_25291(class_10799.field_56883, ARROW_TEXTURE, arrowX, arrowY, 5.0f, 0.0f, 5, 9, 10, 9, 0x40000000);
            graphics.method_25291(class_10799.field_56883, ARROW_TEXTURE, arrowX, arrowY, 0.0f, 0.0f, 5, 9, 10, 9, -1879048192);
        }
        int lineHeight = this.getLineHeight();
        int scrollAmount = 0;
        if (this.scrollbar != null) {
            scrollAmount = this.scrollbar.getScrollAmount();
        }
        int backgroundColor = this.overlayMode ? -369098752 : 0x40000000;
        graphics.method_44379(this.visibleDim.x(), this.visibleDim.y(), this.visibleDim.getLimitX(), this.visibleDim.getLimitY());
        graphics.method_25294(this.visibleDim.x(), this.visibleDim.y(), this.visibleDim.getLimitX(), this.visibleDim.getLimitY(), backgroundColor);
        graphics.method_71048();
        for (int i = 0; i < this.content.size(); ++i) {
            graphics.method_35720(this.font, this.content.get(i), this.visibleDim.x() + 4, this.visibleDim.y() + 4 + i * lineHeight - scrollAmount, -1);
        }
        graphics.method_44380();
    }

    public boolean mouseScrolled(double d, double e, double amount) {
        if (this.visibleDim != null && this.visibleDim.containsCursor(d, e) && this.scrollbar != null) {
            this.scrollbar.scroll((int)(-amount * 10.0));
            return true;
        }
        return false;
    }

    public void setReservedAreaTopLeftCorner(int x, int y) {
        this.reservedArea.set(x - 3, y - 3);
    }

    public static interface TooltipParent {
        public <T extends class_364 & class_4068> T method_37063(T var1);

        public void method_37066(class_364 var1);
    }
}

