/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.recipecommands_common_neoforge.cmds;

import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.StringFunctions;
import com.natamus.recipecommands_common_neoforge.util.Recipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class CommandRecipes {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"recipes").requires(iCommandSender -> iCommandSender.getEntity() instanceof ServerPlayer)).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            CommandRecipes.sendUsage(source);
            return 1;
        })).then(Commands.argument((String)"recipe", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.RECIPE)).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                CommandRecipes.sendRecipe((CommandContext<CommandSourceStack>)command);
            }
            catch (Exception ex) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Unable to find recipe.", (ChatFormatting)ChatFormatting.RED);
            }
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rec").requires(iCommandSender -> iCommandSender.getEntity() instanceof ServerPlayer)).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            CommandRecipes.sendUsage(source);
            return 1;
        })).then(Commands.argument((String)"recipe", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.RECIPE)).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                CommandRecipes.sendRecipe((CommandContext<CommandSourceStack>)command);
            }
            catch (Exception ex) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Unable to find recipe.", (ChatFormatting)ChatFormatting.RED);
            }
            return 1;
        })));
    }

    private static void sendUsage(CommandSourceStack source) {
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Recipe Commands Usage:", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /rec <recipe>", (ChatFormatting)ChatFormatting.DARK_GREEN);
    }

    private static void sendRecipe(CommandContext<CommandSourceStack> command) throws CommandSyntaxException, NoSuchMethodError {
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        Registry itemRegistry = level.registryAccess().lookupOrThrow(Registries.ITEM);
        RecipeHolder recipeHolder = ResourceKeyArgument.getRecipe(command, (String)"recipe");
        Recipe recipe = recipeHolder.value();
        String recipeName = recipeHolder.id().toString();
        if (recipeName.contains(":")) {
            recipeName = recipeName.split(":")[1];
        }
        ArrayList<String> items = new ArrayList<String>();
        HashMap<String, Integer> itemcount = new HashMap<String, Integer>();
        List ingredients = recipe.placementInfo().ingredients();
        for (Ingredient ingredient : ingredients) {
            Set tags;
            Optional optionalItemHolder;
            Optional optionalItemResourceKey;
            List possiblestacks = ingredient.items().toList();
            if (possiblestacks.size() == 0 || (optionalItemResourceKey = ((Holder)possiblestacks.get(0)).unwrapKey()).isEmpty() || (optionalItemHolder = itemRegistry.get((ResourceKey)optionalItemResourceKey.get())).isEmpty()) continue;
            ItemStack itemstack = new ItemStack((Holder)optionalItemHolder.get());
            Item item = itemstack.getItem();
            String itemname = item.toString();
            if (possiblestacks.size() > 1 && !itemname.equalsIgnoreCase("cobblestone") && (tags = itemstack.getTags().collect(Collectors.toSet())).size() > 0) {
                TagKey tag = (TagKey)tags.iterator().next();
                itemname = tag.location().getPath();
            }
            if (itemname.contains(":")) {
                itemname = itemname.split(":")[1];
            }
            if (items.contains(itemname = StringFunctions.capitalizeEveryWord((String)itemname))) {
                itemcount.compute(itemname, (k, currentcount) -> currentcount + 1);
                continue;
            }
            items.add(itemname);
            itemcount.put(itemname, 1);
        }
        Collections.sort(items);
        List pattern = new ArrayList();
        HashMap<String, String> itemkeys = new HashMap<String, String>();
        String outputName = recipeName;
        try {
            ItemStack output = recipe.assemble(null, (HolderLookup.Provider)level.registryAccess());
            outputName = output.getItem().toString();
            if (outputName.contains(":")) {
                outputName = outputName.split(":")[1];
            }
        }
        catch (Exception output) {
            // empty catch block
        }
        String jsonRecipe = Recipes.jsonrecipes.get(recipeName);
        if (jsonRecipe == null) {
            jsonRecipe = Recipes.jsonrecipes.get(outputName);
        }
        String shape = "shaped";
        if (jsonRecipe != null) {
            Gson gson = new Gson();
            Map map = (Map)gson.fromJson(jsonRecipe, Map.class);
            String rawjson = map.toString();
            if (rawjson.contains("shapeless")) {
                shape = "shapeless";
            }
            pattern = (List)map.get("pattern");
            String[] spl1 = rawjson.split("key=\\{");
            if (spl1.length > 1) {
                String keys = spl1[1].split("}},")[0];
                for (String keyraw : keys.split(", ")) {
                    String[] keyspl = keyraw.split("=[{,\\[]");
                    if (keyspl.length <= 1) continue;
                    String key = keyspl[0];
                    if (Recipes.replacekeys.containsKey(key)) {
                        key = Recipes.replacekeys.get(key);
                    }
                    String itemvalue = keyspl[1].split(":")[1].replaceAll("}", "");
                    itemkeys.put(itemvalue, key);
                }
            }
        }
        String formattedOutputName = StringFunctions.capitalizeEveryWord((String)outputName.replace("_", " "));
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)(formattedOutputName + " has a " + shape + " recipe."), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" Ingredients:", (ChatFormatting)ChatFormatting.DARK_GREEN);
        for (String itemname : items) {
            String shapeditemname;
            int count = (Integer)itemcount.get(itemname);
            Object todisplayname = itemname;
            if (shape.equalsIgnoreCase("shaped") && itemkeys.containsKey(shapeditemname = itemname.toLowerCase().replace(" ", "_").split("/")[0])) {
                String itemkey = (String)itemkeys.get(shapeditemname);
                todisplayname = (String)todisplayname + " (" + itemkey + ")";
            }
            todisplayname = ((String)todisplayname).replace("_", " ");
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("  " + count + "x " + (String)todisplayname), (ChatFormatting)ChatFormatting.DARK_GREEN);
        }
        if (shape.equalsIgnoreCase("shaped") && pattern != null && pattern.size() > 0) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" Pattern:", (ChatFormatting)ChatFormatting.DARK_GREEN);
            for (String line : pattern) {
                for (String toreplace : Recipes.replacekeys.keySet()) {
                    line = line.replaceAll(toreplace, Recipes.replacekeys.get(toreplace));
                }
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)("  " + line.replace(" ", "_")), (ChatFormatting)ChatFormatting.DARK_GREEN);
            }
        }
    }
}

