/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.realisticbees_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.SpawnEntityFunctions;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.realisticbees_common_neoforge.config.ConfigHandler;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BeeEvent {
    public static void onBeeCheckSpawn(Mob entity, Level level, BlockPos blockPos, BaseSpawner spawner, EntitySpawnReason spawnReason) {
        if (!(entity instanceof Bee)) {
            return;
        }
        entity.addTag("SpawnReason." + spawnReason.name());
    }

    public static void onBeeSpawn(Entity entity, Level level) {
        if (level.isClientSide()) {
            return;
        }
        if (!(entity instanceof Bee)) {
            return;
        }
        Set tags = entity.getTags();
        if (tags.contains("realisticbees.ignorebee")) {
            return;
        }
        entity.addTag("realisticbees.ignorebee");
        if (tags.contains("SpawnReason.BUCKET") || tags.contains("SpawnReason.SPAWN_EGG")) {
            return;
        }
        BlockPos entitypos = entity.blockPosition();
        if (!level.hasChunk(Mth.floor((float)entitypos.getX()) >> 4, Mth.floor((float)entitypos.getZ()) >> 4)) {
            return;
        }
        int extrabees = ConfigHandler.extraBeeSpawnsPerBee;
        if (extrabees == 0) {
            return;
        }
        Bee bee = (Bee)entity;
        if (bee.isBaby()) {
            return;
        }
        TaskFunctions.enqueueImmediateTask((Level)level, () -> {
            Vec3 beevec = entity.position();
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < extrabees; ++i) {
                Bee newbee = (Bee)EntityType.BEE.create(level, EntitySpawnReason.NATURAL);
                newbee.setPos(beevec.x, beevec.y, beevec.z);
                newbee.addTag("realisticbees.ignorebee");
                SpawnEntityFunctions.spawnEntityOnNextTick((ServerLevel)serverLevel, (Entity)newbee);
            }
        }, (boolean)false);
    }
}

