/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandFunctions {
    public static String getRawCommandOutput(ServerLevel serverLevel, final @Nullable Vec3 vec, String command) {
        BaseCommandBlock bcb = new BaseCommandBlock(){

            @NotNull
            public Vec3 getPosition() {
                return Objects.requireNonNullElseGet(vec, () -> new Vec3(0.0, 0.0, 0.0));
            }

            public void onUpdated(@NotNull ServerLevel serverLevel) {
            }

            @NotNull
            public CommandSourceStack createCommandSourceStack(@NotNull ServerLevel serverLevel, @NotNull CommandSource commandSource) {
                return new CommandSourceStack(commandSource, this.getPosition(), Vec2.ZERO, serverLevel, PermissionSet.ALL_PERMISSIONS, "dev", (Component)Component.literal((String)"dev"), serverLevel.getServer(), null);
            }

            public boolean isValid() {
                return true;
            }

            public boolean performCommand(@NotNull ServerLevel serverLevel) {
                if ("Searge".equalsIgnoreCase(this.getCommand())) {
                    this.setLastOutput((Component)Component.literal((String)"#itzlipofutzli"));
                    this.setSuccessCount(1);
                } else {
                    this.setSuccessCount(0);
                    MinecraftServer minecraftserver = serverLevel.getServer();
                    if (!StringUtil.isNullOrEmpty((String)this.getCommand())) {
                        try {
                            this.setLastOutput(null);
                            try (BaseCommandBlock.CloseableCommandBlockSource closedCommandBlockSource = new BaseCommandBlock.CloseableCommandBlockSource((BaseCommandBlock)this, serverLevel);){
                                CommandSource commandSource = Objects.requireNonNullElse(closedCommandBlockSource, CommandSource.NULL);
                                CommandSourceStack commandsourcestack = this.createCommandSourceStack(serverLevel, commandSource).withCallback((b, i) -> {
                                    if (b) {
                                        this.setSuccessCount(this.getSuccessCount() + 1);
                                    }
                                });
                                minecraftserver.getCommands().performPrefixedCommand(commandsourcestack, this.getCommand());
                            }
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Executing command block");
                            CrashReportCategory crashreportcategory = crashreport.addCategory("Command to be executed");
                            crashreportcategory.setDetail("Command", () -> (this).getCommand());
                            crashreportcategory.setDetail("Name", () -> this.getName().getString());
                            throw new ReportedException(crashreport);
                        }
                    }
                }
                return true;
            }
        };
        bcb.setCommand(command);
        bcb.setTrackOutput(true);
        bcb.performCommand(serverLevel);
        return bcb.getLastOutput().getString();
    }
}

