/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.ImmutableList;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import snownee.jade.util.JadeMetadata;

public class FabricJadeMetadata
extends JadeMetadata {
    public FabricJadeMetadata() {
        ImmutableList.Builder disableModNameBuilder = ImmutableList.builder();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = container.getMetadata();
            if (!metadata.containsCustomValue("jade") || metadata.getCustomValue("jade").getType() != CustomValue.CvType.OBJECT) continue;
            CustomValue.CvObject obj = metadata.getCustomValue("jade").getAsObject();
            this.accessibilityMod |= FabricJadeMetadata.getBool(obj, "accessibilityMod");
            this.fastScroll |= FabricJadeMetadata.getBool(obj, "fastScroll");
            this.smoothScroll |= FabricJadeMetadata.getBool(obj, "smoothScroll");
            if (!FabricJadeMetadata.getBool(obj, "disableItemModNameTooltip")) continue;
            disableModNameBuilder.add((Object)metadata.getId());
        }
        this.disableItemModNameTooltip = disableModNameBuilder.build();
    }

    private static boolean getBool(CustomValue.CvObject obj, String key) {
        if (!obj.containsKey(key)) {
            return false;
        }
        CustomValue value = obj.get(key);
        if (value.getType() != CustomValue.CvType.BOOLEAN) {
            return false;
        }
        return value.getAsBoolean();
    }
}

