/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import snownee.jade.gui.config.value.OptionValue;

public class SliderOptionValue
extends OptionValue<Float> {
    private final Slider slider;
    private float min;
    private float max;
    private FloatUnaryOperator aligner;

    public SliderOptionValue(String optionName, Supplier<Float> getter, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        super(optionName, getter, setter);
        this.value = getter.get();
        this.min = min;
        this.max = max;
        this.aligner = aligner;
        this.slider = new Slider(this, 0, 0, 100, 20, this.title());
        this.updateValue();
        this.addWidget((class_339)this.slider, 0);
    }

    @Override
    public void setValue(Float value) {
        this.slider.setValue(value.floatValue(), true);
    }

    @Override
    public void updateValue() {
        this.value = this.getter.get();
        this.slider.setValue(((Float)this.value).floatValue(), false);
    }

    public static class Slider
    extends class_357 {
        private static final DecimalFormat fmt = new DecimalFormat("##.##");
        private final SliderOptionValue parent;

        public Slider(SliderOptionValue parent, int x, int y, int width, int height, class_2561 message) {
            super(x, y, width, height, message, Slider.fromScaled(((Float)parent.value).floatValue(), parent.min, parent.max));
            this.parent = parent;
            this.method_25346();
        }

        public static double fromScaled(float f, float min, float max) {
            return class_3532.method_15363((float)((f - min) / (max - min)), (float)0.0f, (float)1.0f);
        }

        public float toScaled() {
            float f = this.parent.aligner.apply(this.parent.min + (this.parent.max - this.parent.min) * (float)this.field_22753);
            String s = fmt.format(f);
            try {
                return fmt.parse(s).floatValue();
            }
            catch (ParseException e) {
                return f;
            }
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)fmt.format(this.toScaled())));
        }

        protected void method_25344() {
            float scaled = this.toScaled();
            if (((Float)this.parent.value).floatValue() != scaled) {
                this.parent.value = Float.valueOf(scaled);
                this.parent.save();
            }
        }

        private void setValue(float value, boolean applyValue) {
            if (value != this.toScaled()) {
                this.field_22753 = Slider.fromScaled(value, this.parent.min, this.parent.max);
                if (applyValue) {
                    this.method_25344();
                }
            }
            this.method_25346();
        }

        protected class_5250 method_25360() {
            return class_5244.method_37111((class_2561[])new class_2561[]{this.parent.title(), super.method_25360()});
        }
    }
}

