/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_339;
import net.minecraft.class_342;
import snownee.jade.gui.config.value.OptionValue;

public class InputOptionValue<T>
extends OptionValue<T> {
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?[0-9]+");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*[.,][0-9]+|[0-9]+)");
    private final class_342 textField;
    private final Predicate<String> validator;

    public InputOptionValue(Runnable responder, String optionName, Supplier<T> getter, Consumer<T> setter, Predicate<String> validator) {
        super(optionName, getter, setter);
        this.validator = validator;
        this.textField = new class_342(this.font, 0, 0, 98, 18, this.title());
        this.updateValue();
        this.textField.method_1863(s -> {
            if (this.validator.test((String)s)) {
                this.setValue((String)s);
                this.textField.method_1868(Objects.requireNonNull(class_124.field_1068.method_532()) | 0xFF000000);
            } else {
                this.textField.method_1868(Objects.requireNonNull(class_124.field_1061.method_532()) | 0xFF000000);
            }
            responder.run();
        });
        this.addWidget((class_339)this.textField, 0);
    }

    @Override
    public boolean isValidValue() {
        return this.validator.test(this.textField.method_1882());
    }

    @Override
    public void setValue(T value) {
        this.textField.method_1852(String.valueOf(value));
    }

    @Override
    private void setValue(String text) {
        if (this.value instanceof String) {
            this.value = text;
        }
        try {
            Object object = this.value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Short.class, Byte.class, Long.class, Double.class, Float.class}, (Object)object2, n)) {
                case 0: {
                    Integer ignored = (Integer)object2;
                    this.value = Integer.valueOf(text);
                    break;
                }
                case 1: {
                    Short ignored = (Short)object2;
                    this.value = Short.valueOf(text);
                    break;
                }
                case 2: {
                    Byte ignored = (Byte)object2;
                    this.value = Byte.valueOf(text);
                    break;
                }
                case 3: {
                    Long ignored = (Long)object2;
                    this.value = Long.valueOf(text);
                    break;
                }
                case 4: {
                    Double ignored = (Double)object2;
                    this.value = Double.valueOf(text);
                    break;
                }
                case 5: {
                    Float ignored = (Float)object2;
                    this.value = Float.valueOf(text);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.save();
    }

    @Override
    public void updateValue() {
        Object newValue = this.getter.get();
        if (!Objects.equals(this.value, newValue)) {
            this.value = newValue;
            this.textField.method_1852(String.valueOf(this.value));
        }
    }
}

